/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import com.noelios.restlet.authentication.AuthenticationUtils;
import com.noelios.restlet.http.CookieUtils;
import com.noelios.restlet.http.HttpCall;
import com.noelios.restlet.http.HttpConverter;
import com.noelios.restlet.http.HttpRequest;
import com.noelios.restlet.http.HttpResponse;
import com.noelios.restlet.http.HttpServerCall;
import com.noelios.restlet.http.HttpUtils;
import com.noelios.restlet.util.Base64;
import com.noelios.restlet.util.RangeUtils;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.CookieSetting;
import org.restlet.data.Dimension;
import org.restlet.data.Encoding;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.util.DateUtils;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServerConverter
extends HttpConverter {
    public static void addEntityHeaders(Representation entity, Series<Parameter> responseHeaders) {
        if (entity == null) {
            responseHeaders.add("Content-Length", "0");
        } else {
            long size;
            StringBuilder value;
            if (entity.getExpirationDate() != null) {
                responseHeaders.add("Expires", HttpCall.formatDate(entity.getExpirationDate(), false));
            }
            if (!entity.getEncodings().isEmpty()) {
                value = new StringBuilder();
                for (Encoding encoding : entity.getEncodings()) {
                    if (encoding.equals(Encoding.IDENTITY)) continue;
                    if (value.length() > 0) {
                        value.append(", ");
                    }
                    value.append(encoding.getName());
                }
                if (value.length() > 0) {
                    responseHeaders.add("Content-Encoding", value.toString());
                }
            }
            if (!entity.getLanguages().isEmpty()) {
                value = new StringBuilder();
                for (int i = 0; i < entity.getLanguages().size(); ++i) {
                    if (i > 0) {
                        value.append(", ");
                    }
                    value.append(entity.getLanguages().get(i).getName());
                }
                responseHeaders.add("Content-Language", value.toString());
            }
            if (entity.getMediaType() != null) {
                StringBuilder contentType = new StringBuilder(entity.getMediaType().getName());
                if (entity.getCharacterSet() != null) {
                    contentType.append("; charset=").append(entity.getCharacterSet().getName());
                }
                for (Parameter parameter : entity.getMediaType().getParameters()) {
                    contentType.append("; ").append(parameter.getName()).append("=").append(parameter.getValue());
                }
                responseHeaders.add("Content-Type", contentType.toString());
            }
            if (entity.getModificationDate() != null) {
                responseHeaders.add("Last-Modified", HttpCall.formatDate(entity.getModificationDate(), false));
            }
            if (entity.getTag() != null) {
                responseHeaders.add("ETag", entity.getTag().format());
            }
            if ((size = entity.getAvailableSize()) != -1L) {
                responseHeaders.add("Content-Length", Long.toString(size));
            }
            if (entity.getIdentifier() != null) {
                responseHeaders.add("Content-Location", entity.getIdentifier().toString());
            }
            if (entity.isDownloadable() && entity.getDownloadName() != null) {
                responseHeaders.add("Content-Disposition", HttpServerCall.formatContentDisposition(entity.getDownloadName()));
            }
            if (entity.getRange() != null) {
                try {
                    responseHeaders.add("Content-Range", RangeUtils.formatContentRange(entity.getRange(), entity.getSize()));
                }
                catch (Exception e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Unable to format the HTTP Content-Range header", e);
                }
            }
            if (entity.getDigest() != null && "MD5".equals(entity.getDigest().getAlgorithm())) {
                responseHeaders.add("Content-MD5", new String(Base64.encode(entity.getDigest().getValue(), false)));
            }
        }
    }

    public static void addResponseHeaders(Response response, Series<Parameter> responseHeaders) throws IllegalArgumentException {
        Set<Dimension> dimensions;
        String vary;
        if (response.getStatus().equals(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED) || Method.OPTIONS.equals(response.getRequest().getMethod())) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Method method : response.getAllowedMethods()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(method.getName());
            }
            responseHeaders.add("Allow", sb.toString());
        }
        responseHeaders.add("Date", DateUtils.format(new Date(), DateUtils.FORMAT_RFC_1123.get(0)));
        Series<CookieSetting> cookies = response.getCookieSettings();
        for (int i = 0; i < cookies.size(); ++i) {
            responseHeaders.add("Set-Cookie", CookieUtils.format((CookieSetting)cookies.get(i)));
        }
        if (response.getLocationRef() != null) {
            responseHeaders.add("Location", response.getLocationRef().toString());
        }
        if (response.getChallengeRequests() != null) {
            for (ChallengeRequest challengeRequest : response.getChallengeRequests()) {
                responseHeaders.add("WWW-Authenticate", AuthenticationUtils.format(challengeRequest));
            }
        }
        if (!(response.getRequest().getClientInfo().getAgent() != null && response.getRequest().getClientInfo().getAgent().contains("MSIE") || (vary = HttpUtils.createVaryHeader(dimensions = response.getDimensions())) == null)) {
            responseHeaders.add("Vary", vary);
        }
        if (response.getServerInfo().isAcceptRanges()) {
            responseHeaders.add("Accept-Ranges", "bytes");
        }
    }

    public HttpServerConverter(Context context) {
        super(context);
    }

    protected void addEntityHeaders(HttpResponse response) {
        Series<Parameter> responseHeaders = response.getHttpCall().getResponseHeaders();
        Representation entity = response.getEntity();
        HttpServerConverter.addEntityHeaders(entity, responseHeaders);
    }

    protected void addResponseHeaders(HttpResponse response) {
        Series<Parameter> responseHeaders = response.getHttpCall().getResponseHeaders();
        try {
            HttpServerConverter.addResponseHeaders(response, responseHeaders);
            Series additionalHeaders = (Series)response.getAttributes().get("org.restlet.http.headers");
            this.addAdditionalHeaders(responseHeaders, additionalHeaders);
            response.getHttpCall().getResponseHeaders().add("Server", response.getServerInfo().getAgent());
            if (response.getStatus() != null) {
                response.getHttpCall().setStatusCode(response.getStatus().getCode());
                response.getHttpCall().setReasonPhrase(response.getStatus().getDescription());
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.INFO, "Exception intercepted while adding the response headers", e);
            response.getHttpCall().setStatusCode(Status.SERVER_ERROR_INTERNAL.getCode());
            response.getHttpCall().setReasonPhrase(Status.SERVER_ERROR_INTERNAL.getDescription());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(HttpResponse response) {
        try {
            if (response.getRequest().getMethod() != null && response.getRequest().getMethod().equals(Method.HEAD)) {
                this.addEntityHeaders(response);
                response.setEntity(null);
            } else if (response.getStatus().equals(Status.SUCCESS_NO_CONTENT)) {
                this.addEntityHeaders(response);
                if (response.isEntityAvailable()) {
                    this.getLogger().fine("Responses with a 204 (No content) status generally don't have an entity. Only adding entity headers for resource \"" + response.getRequest().getResourceRef() + ".");
                    response.setEntity(null);
                }
            } else if (response.getStatus().equals(Status.SUCCESS_RESET_CONTENT)) {
                if (response.isEntityAvailable()) {
                    this.getLogger().warning("Responses with a 205 (Reset content) status can't have an entity. Ignoring the entity for resource \"" + response.getRequest().getResourceRef() + ".");
                    response.setEntity(null);
                }
            } else if (response.getStatus().equals(Status.REDIRECTION_NOT_MODIFIED)) {
                this.addEntityHeaders(response);
                if (response.isEntityAvailable()) {
                    this.getLogger().warning("Responses with a 304 (Not modified) status can't have an entity. Only adding entity headers for resource \"" + response.getRequest().getResourceRef() + ".");
                    response.setEntity(null);
                }
            } else if (response.getStatus().isInformational()) {
                if (response.isEntityAvailable()) {
                    this.getLogger().warning("Responses with an informational (1xx) status can't have an entity. Ignoring the entity for resource \"" + response.getRequest().getResourceRef() + ".");
                    response.setEntity(null);
                }
            } else {
                this.addEntityHeaders(response);
                if (response.getEntity() != null && !response.getEntity().isAvailable()) {
                    this.getLogger().warning("A response with an unavailable entity was returned. Ignoring the entity for resource \"" + response.getRequest().getResourceRef() + ".");
                    response.setEntity(null);
                }
            }
            this.addResponseHeaders(response);
            response.getHttpCall().sendResponse(response);
        }
        catch (Exception e) {
            if (response.getHttpCall().isConnectionBroken(e)) {
                this.getLogger().log(Level.INFO, "The connection was broken. It was probably closed by the client.", e);
            } else {
                this.getLogger().log(Level.SEVERE, "An exception occured writing the response entity", e);
                response.getHttpCall().setStatusCode(Status.SERVER_ERROR_INTERNAL.getCode());
                response.getHttpCall().setReasonPhrase("An exception occured writing the response entity");
                response.setEntity(null);
                try {
                    response.getHttpCall().sendResponse(response);
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.WARNING, "Unable to send error response", ioe);
                }
            }
        }
        finally {
            response.getHttpCall().complete();
        }
    }

    public HttpRequest toRequest(HttpServerCall httpCall) {
        HttpRequest result = new HttpRequest(this.getContext(), httpCall);
        result.getAttributes().put("org.restlet.http.headers", httpCall.getRequestHeaders());
        if (httpCall.getVersion() != null) {
            result.getAttributes().put("org.restlet.http.version", httpCall.getVersion());
        }
        if (httpCall.isConfidential()) {
            Integer keySize;
            String cipherSuite;
            List<Certificate> clientCertificates = httpCall.getSslClientCertificates();
            if (clientCertificates != null) {
                result.getAttributes().put("org.restlet.https.clientCertificates", clientCertificates);
            }
            if ((cipherSuite = httpCall.getSslCipherSuite()) != null) {
                result.getAttributes().put("org.restlet.https.cipherSuite", cipherSuite);
            }
            if ((keySize = httpCall.getSslKeySize()) != null) {
                result.getAttributes().put("org.restlet.https.keySize", keySize);
            }
        }
        return result;
    }
}

