/*
 * Decompiled with CFR 0.152.
 */
package sim.application;

import components.FilesMap;
import components.Helper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import models.simulation.Structure;
import models.style.Style;
import parsers.auto.Auto;
import parsers.shared.Palette;

public class Application {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String error = null;
        int version = Application.getVersion();
        if (version < 8) {
            error = "This application requires a java JDK or JRE 8 or above.";
        }
        if (Application.CheckError(error).booleanValue()) {
            return;
        }
        if (args.length != 2) {
            error = "This application requires exactly 2 parameters.";
        }
        if (Application.CheckError(error).booleanValue()) {
            return;
        }
        File source = new File(args[0]);
        File dest = new File(args[1]);
        if (!dest.isDirectory()) {
            error = "Second argument must be a path to a folder on your file system. Converted results will be saved in this folder.";
        }
        if (!source.isDirectory()) {
            error = "First argument must be a path to a folder on your file system. The folder should contain the simulation outputs only.";
        }
        if (Application.CheckError(error).booleanValue()) {
            return;
        }
        try {
            System.out.println("reading source files...");
            FilesMap map = Application.GetFilesMap(source);
            map.Mark(0);
            Auto parser = new Auto();
            System.out.println("converting source files to new specification...");
            Structure structure = parser.Parse(map);
            Palette palParser = new Palette();
            System.out.println("converting palette if provided...");
            Style style = palParser.Parse(map);
            map.Close();
            System.out.println("zipping everything...");
            byte[] zip = Helper.MakeZip(structure, style);
            String path = dest + "\\" + structure.getName() + ".zip";
            System.out.println("writing to destination folder...");
            FileOutputStream fos = new FileOutputStream(path);
            fos.write(zip);
            fos.close();
            System.out.println("finished successfully.");
        }
        catch (Exception ex) {
            error = ex.getMessage();
        }
        finally {
            Application.CheckError(error);
        }
    }

    public static Boolean CheckError(String error) {
        if (error == null) {
            return false;
        }
        System.out.println(error);
        return true;
    }

    public static FilesMap GetFilesMap(File folder) throws Exception {
        FilesMap map = new FilesMap();
        File[] files = folder.listFiles();
        if (files.length == 0) {
            throw new Exception("Folder is empty.");
        }
        for (File file : files) {
            if (file.isDirectory()) continue;
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fis);
            map.put(file.getName(), bis);
        }
        return map;
    }

    private static int getVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }
}

