/*
 * Decompiled with CFR 0.152.
 */
package parsers.cadmium;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import components.FilesMap;
import components.Helper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import models.simulation.IEmitter;
import models.simulation.MessageCA;
import models.simulation.Model;
import models.simulation.ModelCA;
import models.simulation.Port;
import models.simulation.Structure;
import models.simulation.StructureInfo;
import parsers.ILogParser;
import parsers.cadmium.config.celldevs.Model;

public class CellDevs
implements ILogParser {
    private static final String TEMPLATE = "{\"value\":${0}}";

    @Override
    public Structure Parse(FilesMap files) throws IOException {
        Structure structure = this.ParseStructure(files.FindStream(".json"));
        structure.setInfo(new StructureInfo(files.FindName("message"), "Cadmium", "Cell-DEVS"));
        this.ParseLog(structure, files.FindStream("message"));
        return structure;
    }

    public Structure ParseStructure(InputStream json) throws IOException {
        Structure s = new Structure();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(json);
        Model jModel = mapper.treeToValue(node.get("scenario"), Model.class);
        ModelCA sModel = s.CreateModelCA(jModel.getName(), Model.Type.COUPLED, TEMPLATE);
        sModel.setSize(jModel.getSize());
        jModel.getPorts().forEach(p -> {
            Port.Type pType = p.getType() == "output" ? Port.Type.OUTPUT : Port.Type.INPUT;
            s.CreatePort(sModel, p.getName(), pType, TEMPLATE);
        });
        return s;
    }

    private void ParseLog(Structure structure, InputStream log) throws IOException {
        ArrayList messages = new ArrayList();
        Helper.ReadFile(log, l -> {
            if (l.startsWith("[")) {
                int i = l.indexOf(93) + 1;
                String right = l.substring(i);
                String model = right.trim().split(" ")[3];
                model = model.substring(0, model.indexOf("(") - 1);
                String left = l.substring(0, i);
                String clean = left.substring(1, left.length() - 1).replace(" ", "").replace("::", ":");
                Arrays.stream(clean.split("\\}")).forEach(s -> {
                    String[] e = s.split(":");
                    String[] data = e[e.length - 1].replaceAll("\\(|\\)|\\{|\\}|<|>", "").split(";");
                    String[] sC = data[0].split(",");
                    int[] coord = new int[]{Integer.parseInt(sC[0]), Integer.parseInt(sC[1]), sC.length == 2 ? 0 : Integer.parseInt(sC[2])};
                    String[] values = data[1].split(",");
                    for (int j = 0; j < values.length; ++j) {
                        messages.add(new MessageCA(structure.getTimesteps().size() - 2, (IEmitter)structure.getPorts().get(j), coord, values[j]));
                    }
                });
            } else {
                structure.getTimesteps().add(l);
            }
        });
        structure.getTimesteps().remove(0);
        structure.setMessages(messages);
    }

    @Override
    public Boolean Validate(FilesMap files) throws IOException {
        BufferedInputStream messages = files.FindStream("message");
        if (messages == null) {
            return false;
        }
        List<String> lines = Helper.ReadNLines(messages, 3);
        ((InputStream)messages).reset();
        long n1 = lines.get(2).chars().filter(c -> c == 40).count();
        long n2 = lines.get(2).chars().filter(c -> c == 41).count();
        return n1 == 2L && n2 == 2L;
    }
}

