#!/bin/sh

DIR=`dirname $0`

player="${DIR}/helios_player"
coach="${DIR}/helios_coach"
teamname="HELIOS2008"
host="localhost"
port=6000
coach_port=""

config="${DIR}/player.conf"
config_dir="${DIR}/formations-433"

coach_config="${DIR}/coach.conf"

savior="on"

sleepprog=sleep
goaliesleep=1
sleeptime=0

usage()
{
  (echo "Usage: $0 [options]"
   echo "Possible options are:"
   echo "      --help                print this"
   echo "  -h, --host HOST           specifies server host"
   echo "  -p, --port PORT           specifies server port"
   echo "  -P  --coach-port PORT     specifies server port for online coach"
   echo "  -t, --teamname TEAMNAME   specifies team name"
   echo "  --savior (on|off)         enable/disable savior") 1>&2
}

while [ $# -gt 0 ]
do
  case $1 in

    --help)
      usage
      exit 0
      ;;

    -h|--host)
      if [ $# -lt 2 ]; then
        usage
        exit 1
      fi
      host=$2
      shift 1
      ;;

    -p|--port)
      if [ $# -lt 2 ]; then
        usage
        exit 1
      fi
      port=$2
      shift 1
      ;;

    -P|--coach-port)
      if [ $# -lt 2 ]; then
        usage
        exit 1
      fi
      coach_port=$2
      shift 1
      ;;

    -t|--teamname)
      if [ $# -lt 2 ]; then
        usage
        exit 1
      fi
      teamname=$2
      shift 1
      ;;

    --savior)
      if [ $# -lt 2 ]; then
        usage
        exit 1
      fi
      savior=$2
      shift 1
      ;;

    *)
      usage
      exit 1
      ;;
  esac

  shift 1
done

if [ $savior = "on" ] ; then
  savior="--savior on "
elif [ $savior = "off" ] ; then
  savior="--savior off "
else
  usage
  exit 1
fi

if [ X"${coach_port}" = X'' ]; then
  coach_port=`expr ${port} + 2`
fi

echo "******************************************************************"
echo " HELIOS2008"
echo " National Institute of Advanced Industrial Science and Technology"
echo " Created by Hidehisa Akiyama and Hiroki Shimora"
echo " Copyright 2000-2007.  Hidehisa Akiyama"
echo " Copyright 2007-2008.  Hidehisa Akiyama and Hiroki Shimora"
echo " All rights reserved."
echo "******************************************************************"

opt="--player-config ${config} --config_dir ${config_dir}"
opt="${opt} -h ${host} -p ${port} -t ${teamname}"
opt="${opt} ${savior}"

$player ${opt} -g &
$sleepprog $goaliesleep

i=2
while [ $i -le 11 ] ; do
  $player ${opt} &
  $sleepprog $sleeptime
  i=`expr $i + 1`
done

coachopt="--coach-config ${coach_config}"
coachopt="${coachopt} -h ${host} -p ${coach_port} -t ${teamname}"

$coach ${coachopt} &
