/*******************************************************************
*
*  DESCRIPTION: class Workstation2
*
*  AUTHOR:  Shanta Ramchandani
*
*  EMAIL: shantar@sympatico.ca
*
*  DATE: October 20, 2003
*
*******************************************************************/

#ifndef __WORKSTATION2_H
#define __WORKSTATION2_H

#include <list>
#include "atomic.h"     // class Atomic

/** forward declarations **/
class Distribution ;

class Workstation2 : public Atomic
{
public:
	Workstation2( const string &name = "Workstation2" );		//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:

	const Port &in1;
	const Port &in2; 
	const Port &numBuf1;
	const Port &numBuf2;
	Port &out;
	Port &ready;


	int sizeBuffer1;
	int sizeBuffer2;

	int in1Value;
	int in2Value;

	int product;
	int partsReady;
	int createProduct;



	Distribution *dist ;

	Distribution &distribution()
			{return *dist;}

	
};	// class Workstation2

// ** inline ** // 
inline
string Workstation2::className() const
{
	return "Workstation2" ;
}

#endif   //__WORKSTATION2_H
