/*******************************************************************
*
*  DESCRIPTION: class Workstation2
*
*  AUTHOR:  Shanta Ramchandani
*
*  EMAIL: shantar@sympatico.ca
*
*  DATE: October 20, 2003
*
*******************************************************************/

/** include files **/
#include "workstation2.h"
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )
#include "distri.h"     // class Distribution


/** public functions **/

/*******************************************************************
* Function Name: Workstation2
* Description: 
********************************************************************/
Workstation2::Workstation2( const string &name )
: Atomic( name )
, in1( addInputPort( "in1" ) )
, in2( addInputPort( "in2" ) )
, numBuf1 ( addInputPort ( "numBuf1" ) )
, numBuf2 ( addInputPort ( "numBuf2" ) )
, out( addOutputPort( "out" ) )
, ready( addOutputPort( "ready" ) )

{

		dist = Distribution::create( MainSimulator::Instance().getParameter( description(), "distribution" ) );
		MASSERT( dist ) ;
		for ( register int i = 0; i < dist->varCount(); i++ )
		{
			string parameter( MainSimulator::Instance().getParameter( description(), dist->getVar( i ) ) ) ;
			dist->setVar( i, str2Value( parameter ) ) ;
		}

}

/*******************************************************************
* Function Name: initFunction
* Description: 
********************************************************************/
Model &Workstation2::initFunction()
{
	in1Value = 0;
	in2Value = 0;
	sizeBuffer1 = 0;
	sizeBuffer2 = 0;
	product = 1;
	partsReady = 0;
	createProduct = 0;

	passivate();

	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: If the number of elements in both buffers shown by 'numBuf1'
*		   and 'numBuf2' then send 'ready' output but only if not busy
*		   creating product.
*		   If receive input from ports 'in1' and 'in2' then spend some time
* 		   creating product and then output.
********************************************************************/
Model &Workstation2::externalFunction( const ExternalMessage &msg )
{
																		
	if (msg.port() == in1) {
		if(msg.value() != 1) product = (int)msg.value();
		in1Value = 1;	
		if (in1Value != 0 && in2Value != 0) createProduct = 1;
		holdIn( active, Time( static_cast< float >( fabs( distribution().get() ) ) ) ) ; 
	}

	else if (msg.port() == in2) {
		if(msg.value() != 1) product = (int)msg.value();
		in2Value = 1;	
		if (in1Value != 0 && in2Value != 0) createProduct = 1;
		holdIn( active, Time( static_cast< float >( fabs( distribution().get() ) ) ) ) ; 

	}

	else if (msg.port() == numBuf1) {
		sizeBuffer1 = (int)msg.value();
																		
		if ((sizeBuffer1 > 0) && (sizeBuffer2 > 0)) {
			partsReady = 1;
			if (state() == passive) {
				holdIn( active, Time( static_cast< float >( fabs( distribution().get() ) ) ) ) ; 

			}
		}
	}

	else if (msg.port() == numBuf2) {
		sizeBuffer2 = (int)msg.value();
																		
		if ((sizeBuffer1 > 0) && (sizeBuffer2 > 0)) {
			partsReady = 1;
			if (state() == passive) {
				holdIn( active, Time( static_cast< float >( fabs( distribution().get() ) ) ) ) ; 

			}
		}
	}


	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description: no internal function
********************************************************************/
Model &Workstation2::internalFunction( const InternalMessage & )
{
	passivate();

	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description: 
********************************************************************/
Model &Workstation2::outputFunction( const InternalMessage &msg )
{

	
	if (createProduct == 1) {
																		
		sendOutput( msg.time(), out, product ) ;
		createProduct = 0;

	}

	if ((createProduct == 0)&&(partsReady == 1)) {
																		
		sendOutput( msg.time(), ready, 1) ;
		partsReady = 0;
	}

	return *this ;
}
