/*******************************************************************
*
*  DESCRIPTION: class Workstation1
*
*  AUTHOR:  Shanta Ramchandani
*
*  EMAIL: shantar@sympatico.ca
*
*  DATE: October 20, 2003
*
*******************************************************************/

#ifndef __WORKSTATION1_H
#define __WORKSTATION1_H

#include <list>
#include "atomic.h"     // class Atomic

/** forward declarations **/
class Distribution ;


class Workstation1 : public Atomic
{
public:
	Workstation1( const string &name = "Workstation1" );	 //Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	Port &in;
	Port &numBuf;
	Port &out;
	Port &ready;

	int product;
	int partIn;
	int working;
	int firstProduct;
	int numElemBuf;

	Distribution *dist ;

	Distribution &distribution()
			{return *dist;}
	

};	// class Workstation1

// ** inline ** // 
inline
string Workstation1::className() const
{
	return "Workstation1" ;
}

#endif   //__Workstation1_H
