/*******************************************************************
*
*  DESCRIPTION: class Workstation1
*
*  AUTHOR:  Shanta Ramchandani
*
*  EMAIL: shantar@sympatico.ca
*
*  DATE: October 20, 2003
*
*******************************************************************/

/** include files **/

#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )
#include "distri.h"        // class Distribution
#include "workstation1.h"

/** public functions **/

/*******************************************************************
* Function Name: Workstation1
* Description: 
********************************************************************/
Workstation1::Workstation1( const string &name )
: Atomic( name )
, in( addInputPort( "in" ) )
, numBuf( addInputPort( "numBuf" ) )
, out( addOutputPort( "out" ) )
, ready( addOutputPort( "ready" ) )

{
		dist = Distribution::create( MainSimulator::Instance().getParameter( description(), "distribution" ) );
		MASSERT( dist ) ;
		for ( register int i = 0; i < dist->varCount(); i++ )
		{
			string parameter( MainSimulator::Instance().getParameter( description(), dist->getVar( i ) ) ) ;
			dist->setVar( i, str2Value( parameter ) ) ;
		}
}

/*******************************************************************
* Function Name: initFunction
* Description: 
********************************************************************/
Model &Workstation1::initFunction()
{
	product = 1;	
	partIn = 0;
	working = 0;
	numElemBuf = 0;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: When input is received, wait for a random amount of time
* 		   (time to assemble the product) and then continue
*		   When number of elements in the buffer is received then
*		   goto output function and signal 'ready' if number of elements
*		   is greater than zero.
********************************************************************/
Model &Workstation1::externalFunction( const ExternalMessage &msg )
{
	if (msg.port() == in) {

		partIn = 1;
		working = 1;
		holdIn( active, Time( static_cast< float >( fabs( distribution().get() ) ) ) ) ; 
		
	}
	
	if (msg.port() == numBuf) {
		numElemBuf = (int)msg.value();
		if (working == 0)	holdIn(active, Time::Zero);
	}

	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description: no internal functions
********************************************************************/
Model &Workstation1::internalFunction( const InternalMessage & )
{
	working = 0;
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description: output the product and output a ready signal to identify
*		
********************************************************************/
Model &Workstation1::outputFunction( const InternalMessage &msg )
{
	if (partIn == 1) {
		sendOutput( msg.time(), out, product ) ;
		sendOutput( msg.time(), ready, 1) ;
		partIn = 0;
	}
	if( (numElemBuf > 0) && (working == 0)){
		sendOutput( msg.time(), ready, 1) ;
		
	}
	return *this ;
}
