/*******************************************************************
*
*  DESCRIPTION: class Warehouse
*
*  AUTHOR:  Shanta Ramchandani
*
*  EMAIL: shantar@sympatico.ca
*
*  DATE: October 20, 2003
*
*******************************************************************/

#ifndef __WAREHOUSE_H
#define __WAREHOUSE_H

/** include files **/
#include "atomic.h"     // class Atomic


/** declarations **/
class Warehouse : public Atomic
{
public:
	Warehouse( const string &name = "Warehouse" );	// Default constructor

	~Warehouse();

	virtual string className() const
		{return "Warehouse";}

protected:
	Model &initFunction() ;

	Model &externalFunction( const ExternalMessage & );

	Model &internalFunction( const InternalMessage & );

	Model &outputFunction( const InternalMessage & );

private:
	int     partType;
	Port    &in;
	Port    &out ;

	int 	  NUM_PARTS;

	int     DEBUG;

			
};	// class Warehouse


#endif   //__WAREHOUSE_H 
