/*******************************************************************
*
*  DESCRIPTION: class Warehouse
*
*  AUTHOR:  Shanta Ramchandani
*
*  EMAIL: shantar@sympatico.ca
*
*  DATE: October 20, 2003
*
*******************************************************************/

/** include files **/
#include "warehouse.h"     // base header
#include "message.h"       // class InternalMessage 
#include "mainsimu.h"      // class Simulator (MainSimulator::Instance().getParameter( ... ))

/*******************************************************************
* Function Name: Warehouse
* Description: constructor
********************************************************************/
Warehouse::Warehouse( const string &name )
: Atomic( name )
, in( addInputPort( "in" ) )
, out( addOutputPort( "out" ) )

{
	string debugTemp( MainSimulator::Instance().getParameter( description(), "DEBUG_FLAG" ) ) ;
	if (debugTemp == "1") DEBUG = 1;
	else DEBUG = 0;

	string NUM_PARTStemp( MainSimulator::Instance().getParameter( description(), "NUM_PARTS" ) ) ;
	if (NUM_PARTStemp == "1") NUM_PARTS = 1;
	else if (NUM_PARTStemp == "2") NUM_PARTS = 2;
	else NUM_PARTS = 1;

}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &Warehouse::initFunction()
{
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: On input, it immediately calls the output function
********************************************************************/
Model &Warehouse::externalFunction( const ExternalMessage &msg )
{
	if (msg.port() == in) {

		if (NUM_PARTS == 1) partType = 1;
		else partType = (rand() % NUM_PARTS) + 2; 
		holdIn( active, Time(0,0,0,3) ) ;
	}

	return *this ;
}

/*******************************************************************
* Function Name: internalFunction
* Description:   Always passive since the Warehouse only responds to 
*                external events
********************************************************************/
Model &Warehouse::internalFunction( const InternalMessage & )	
{
	passivate();		
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
********************************************************************/
Model &Warehouse::outputFunction( const InternalMessage &msg )
{
	sendOutput( msg.time(), out, partType ) ;
	return *this ;
}

Warehouse::~Warehouse()
{
	// N/A
}
