/*******************************************************************
*
*  DESCRIPTION: class Sorter
*
*  AUTHOR:  Shanta Ramchandani
*
*  EMAIL: shantar@sympatico.ca
*
*  DATE: October 20, 2003
*
*******************************************************************/

#ifndef __SORTER_H
#define __SORTER_H

#include <list>
#include "atomic.h"     // class Atomic

/** forward declarations **/
class Distribution ;


class Sorter : public Atomic
{
public:
	Sorter( const string &name = "Sorter" );		//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:

	const Port &in;
	const Port &numBuf2;
	const Port &numBuf3;
	Port       &out2;
	Port       &out3;
	Port       &inspectorReady;

	int        buf2Status;
	int        buf3Status;

	int        partType;
	int        working;

	Distribution *dist ;

	Distribution &distribution()
			{return *dist;}

	
};	// class Sorter

// ** inline ** // 
inline
string Sorter::className() const
{
	return "Sorter" ;
}

#endif   //__SORTER_H
