/*******************************************************************
*
*  DESCRIPTION: class Sorter
*
*  AUTHOR:  Shanta Ramchandani
*
*  EMAIL: shantar@sympatico.ca
*
*  DATE: October 20, 2003
*
*******************************************************************/

/** include files **/
#include "sorter.h"
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )
#include "distri.h"     // class Distribution


/** public functions **/

/*******************************************************************
* Function Name: Sorter
* Description: 
********************************************************************/
Sorter::Sorter( const string &name )
: Atomic( name )
, in( addInputPort( "in" ) )
, numBuf2( addInputPort ( "numBuf2" ) )
, numBuf3( addInputPort ( "numBuf3" ) )
, out2( addOutputPort( "out2" ) )
, out3( addOutputPort( "out3" ) )
, inspectorReady( addOutputPort( "inspectorReady" ) )

{

		dist = Distribution::create( MainSimulator::Instance().getParameter( description(), "distribution" ) );
		MASSERT( dist ) ;
		for ( register int i = 0; i < dist->varCount(); i++ )
		{
			string parameter( MainSimulator::Instance().getParameter( description(), dist->getVar( i ) ) ) ;
			dist->setVar( i, str2Value( parameter ) ) ;
		}

}

/*******************************************************************
* Function Name: initFunction
* Description: 
********************************************************************/
Model &Sorter::initFunction()
{
	buf2Status = 0;
	buf3Status = 0;
	
	partType = 0;
	working = 0;

	holdIn(active, Time::Zero); //want to signal an inspectorReady at start-up

	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: 
********************************************************************/
Model &Sorter::externalFunction( const ExternalMessage &msg )
{

																		

	if (msg.port() == numBuf2) {
																		
		buf2Status = (int)msg.value();
		if (working == 0) holdIn( active, Time::Zero) ; 
	}

	else if (msg.port() == numBuf3) {
																		
		buf3Status = (int)msg.value();
		if (working == 0) holdIn( active, Time::Zero) ;
	}

	else if (msg.port() == in) {
		partType = (int)msg.value();
		working = 1;
		holdIn( active, Time( static_cast< float >( fabs( distribution().get() ) ) ) ) ; 
	}

	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description: 
********************************************************************/
Model &Sorter::internalFunction( const InternalMessage & )
{
	working = 0;
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description: 
********************************************************************/
Model &Sorter::outputFunction( const InternalMessage &msg )
{

	if (working == 0 && partType == 0 && ((buf2Status < 2.0) || (buf3Status < 2.0)) ) {
		sendOutput(msg.time(), inspectorReady, 1);
	} else {																		
		if (partType != 0 && working == 1) {
			if (partType == 2 && buf2Status < 2) {
				sendOutput(msg.time(), out2, partType);
				sendOutput(msg.time(), inspectorReady, 1);
				partType = 0;
			} else if (partType == 3 && buf3Status < 2) {
				sendOutput(msg.time(), out3, partType);
				sendOutput(msg.time(), inspectorReady, 1);
				partType = 0;
			}
		}
	}

	return *this ;
}
