/*******************************************************************
*
*  DESCRIPTION: Simulator::registerNewAtomics()
*
*  AUTHOR: Shanta Ramchandani
*
*  EMAIL: mailto: shantar@sympatico.ca
*
*  DATE: October 20, 2003
*
*******************************************************************/

#include "modeladm.h" 
#include "mainsimu.h"
#include "buffer.h"      // class Buffer
#include "warehouse.h"   //class Warehouse
#include "workstation1.h" //class Workstation1
#include "workstation2.h" //class Workstation2
#include "prioritizer.h"  //class Prioritizer
#include "sorter.h"	 //class Sorter


void MainSimulator::registerNewAtomics()
{
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Buffer>() , "Buffer" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Warehouse>() , "Warehouse" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Workstation1>() , "Workstation1" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Workstation2>() , "Workstation2" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Prioritizer>() , "Prioritizer" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Sorter>() , "Sorter" ) ;
}
