/*******************************************************************
*
*  DESCRIPTION: class Prioritizer
*
*  AUTHOR:  Shanta Ramchandani
*
*  EMAIL: shantar@sympatico.ca
*
*  DATE: October 20, 2003
*
*******************************************************************/

#ifndef __PRIORITIZER_H
#define __PRIORITIZER_H

#include <list>
#include "atomic.h"     // class Atomic

/** forward declarations **/
class Distribution ;


class Prioritizer : public Atomic
{
public:
	Prioritizer( const string &name = "Prioritizer" );	//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:

	const Port &in;
	const Port &numBuf1; 
	const Port &numBuf2;
	const Port &numBuf3;
	Port       &out1;
	Port       &out2;
	Port       &out3;
	Port       &inspectorReady;

	int        buf1Status;
	int        buf2Status;
	int        buf3Status;

	int        partType;
	int	       start;		
	int        working;

	Distribution *dist ;

	Distribution &distribution()
			{return *dist;}

	
};	// class Prioritizer

// ** inline ** // 
inline
string Prioritizer::className() const
{
	return "Prioritizer" ;
}

#endif   //__PRIORITIZER_H
