/*******************************************************************
*
*  DESCRIPCION: Cola Genrica con Stop (detiene a la cola)
*
*  AUTORES:
*  		   Ing. Carlos Giorgetti
*          Ivn A. Melgrati
*          Dra. Ana Rosa Tymoschuk
*
*  EMAIL: mailto://cgiorget@frsf.utn.edu.ar
*         mailto://imelgrat@frsf.utn.edu.ar
*         mailto://anrotym@alpha.arcride.edu.ar
*
*  FECHA: 16/10/1999
*
*******************************************************************/
#ifndef __STOPQ_H
#define __STOPQ_H

#include <list.h>
#include "atomic.h"

typedef list<Value> ElementList ;

class StoppableQueue : public Atomic
{
public:
	StoppableQueue( const string &name = "StoppableQueue" );	//Default constructor
    virtual string className() const {  return "StoppableQueue" ;}
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );
private:
	const Port &stop;
    const Port &in;
    Port &out;
    ElementList elements ;
	Time timeLeft;
    Time preparationTime;
    int stopped;
    
};	// class StoppableQueue

#endif   //__QUEUE_H
