/*******************************************************************
*
*  DESCRIPCION: Router (rutea los paquetes de acuerdo a su direccin)
*
*  AUTORES:
*  		   Ing. Carlos Giorgetti
*          Ivn A. Melgrati
*          Dra. Ana Rosa Tymoschuk
*
*  EMAIL: mailto://cgiorget@frsf.utn.edu.ar
*         mailto://imelgrat@frsf.utn.edu.ar
*         mailto://anrotym@alpha.arcride.edu.ar
*
*  FECHA: 18/10/1999
*
*******************************************************************/
#ifndef __ROUTER_H
#define __ROUTER_H
#include <list.h>
#include "atomic.h"

typedef list<Value> ElementList ;

class Router : public Atomic
{
public:
	Router( const string &name = "Router" );					//Default constructor
    virtual string className() const {return "Queue" ;}

protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in;
	Port &out0;
    Port &out1;
    Port &out2;
	Port &out3;
	Port &out4;
	Port &out5;
	Port &out6;
	Port &out7;
	Port &out8;
	Port &out9;
	Port &out10;
	Port &out11;
	Port &out12;
	Port &out13;
    Port &out14;
    Port &out15;

	Time preparationTime;
	ElementList elements ;

	Time timeLeft;

};	// class Queue

#endif   //__ROUTER_H
