/*******************************************************************
*
*  DESCRIPCION: Cola Genrica (on demand)
*
*  AUTORES:
*  		   Ing. Carlos Giorgetti
*          Ivn A. Melgrati
*          Dra. Ana Rosa Tymoschuk
*
*  EMAIL: mailto://cgiorget@frsf.utn.edu.ar
*         mailto://imelgrat@frsf.utn.edu.ar
*         mailto://anrotym@alpha.arcride.edu.ar
*
*  FECHA: 15/10/1999
*
*******************************************************************/
#ifndef __QUEUE_H
#define __QUEUE_H

#include <list.h>
#include "atomic.h"     // class Atomic
#include "time.h"
typedef list<Value> ElementList ;

class Queue : public Atomic
{
public:
	Queue( const string &name = "Queue" );
    virtual string className() const {  return "Queue" ;}
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in;
	const Port &done;
	Port &out;
	ElementList elements ;
        Time preparationTime;
};	// class Queue

#endif   //__QUEUE_H
