/*******************************************************************
*
*  DESCRIPCION: MultiCPU (CPU Multitarea)
*
*  AUTORES:
*  		   Ing. Carlos Giorgetti
*          Ivn A. Melgrati
*          Dra. Ana Rosa Tymoschuk
*
*  EMAIL: mailto://cgiorget@frsf.utn.edu.ar
*         mailto://imelgrat@frsf.utn.edu.ar
*         mailto://anrotym@alpha.arcride.edu.ar
*
*  FECHA: 21/10/1999
*
*******************************************************************/

#ifndef __MULTICPU_H
#define __MULTICPU_H
#include "atomic.h"
#include "mformats.h"
#include "time.h"
#include "distri.h"
const int activo = 1;
const int pasivo = 2;
const int ack = 3;

enum states {firstproccess, diskaccess, finalproccess};       // Estados de la tarea

struct task{
			union request tarea;  	// Datos de la tarea
            enum states state;  	// Estado de la tarea
            };

class MultiCPU: public Atomic
{

public:
	MultiCPU( const string &name = "MultiCPU" ) ;	 // Constructor

	~MultiCPU(void){delete dist;
    				 delete [canttasks] TaskList;
                    }		   						// Destructor

	virtual string className() const  {return "MultiCPU";}

protected:
	Model &initFunction(){return *this;}
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

    Distribution &distribution(){return *dist;}
    void RemoveTask (int index);        		// Eliminar una tarea de la lista
    int FindTask (union request r);     		// Encontrar una tarea en la lista
    int NextTask();								// Buscar siguiente tarea a ejecutar (prioridades)

private:
	const Port &colain;
    const Port &controladorain;
	Port &colaout ;
    Port &controladoraout;
    Port &stopqueue;
    

	Distribution *dist ;				// Distribucin de probabilidad de tiempo de servicio
	union request TareaActual;          // Tarea Actual
    struct task *TaskList;              // Puntero a la lista de tareas
    int maxtareas;                              // Cantidad mxima de tareas
    int canttasks;						// Cantidad actual de tareas
    int estado, anterior;				// Estados actual y anterior del Modelo
    Time TimeLeft;						// Tiempo restante para prximo cambio

};	// class MultiCPU


#endif   //__MultiCPU_H
