/*******************************************************************
*
*  DESCRIPCION: MultiCPU (CPU Multitarea)
*
*  AUTORES:
*  		   Ing. Carlos Giorgetti
*          Ivn A. Melgrati
*          Dra. Ana Rosa Tymoschuk
*
*  EMAIL: mailto://cgiorget@frsf.utn.edu.ar
*         mailto://imelgrat@frsf.utn.edu.ar
*         mailto://anrotym@alpha.arcride.edu.ar
*
*  FECHA: 21/10/1999
*
*******************************************************************/

#include "multicpu.h"
#include "mainsimu.h"
#include "strutil.h"
#include "message.h"
#include "time.h"


void MultiCPU::RemoveTask (int index)
{
	register int i;

    if ((index >= 0) && (index <= canttasks))      // Si el ndice est en rango
    {
    	for (i = index; i <(canttasks - 1); i++)     // Correr todos los elementos un
        	TaskList[i] = TaskList[i+1];   // lugar hacia atrs desde el que se debe eliminar

        canttasks--;							   // Decrementar la cantidad de tareas encoladas
    }
}

int MultiCPU::FindTask (union request re)
{
	register int i;

    for (i = 0; i < canttasks; i++)
    {
    	if (re.r.idtask == TaskList[i].tarea.r.idtask)
        		return (i);           // Si los id de tarea coinciden, devolver el ndice
    }

    return (-1);                      // Si no se lo encuentra, devolver -1
}

int MultiCPU::NextTask()
{
	register int i;

    for (i = 0; i < canttasks; i++)              		// Buscar tareas con procesamiento final
    {
    	if (TaskList[i].state == finalproccess)  // Si se encuentra, devolver ndice de la tarea
        		return (i);
    }

    for (i = 0; i < canttasks; i++)                     // Buscar tareas con procesamiento final
    {
    	if (TaskList[i].state == firstproccess)  // Si se encuentra, devolver ndice de la tarea
        		return (i);
    }

    return (-1);                      			// Si no hay tareas para ejecutar, devolver -1
}

MultiCPU::MultiCPU (const string& name): Atomic(name) , colain(addInputPort( "colain" )),
colaout(addOutputPort("colaout")) , controladorain(addInputPort( "controladorain" )),
controladoraout(addOutputPort("controladoraout")), stopqueue(addOutputPort("stopqueue"))
{
	// Leer datos de la distribucin
    dist = Distribution::create( MainSimulator::Instance().getParameter( description(), "distribution" ) );
	for ( register int i = 0; i < dist->varCount(); i++ )
	{
		string parameter( MainSimulator::Instance().getParameter( description(), dist->getVar( i ) ) ) ;
		dist->setVar( i, str2Value( parameter ) ) ;
	}

    // Leer cantidad mxima de tareas
	if( MainSimulator::Instance().existsParameter( description(), "maxtasks" ) )
		maxtareas = str2Int( MainSimulator::Instance().getParameter( description(), "initial" ) );
	else
		maxtareas = 5;

    // Crear lista de tareas
    TaskList = new struct task[maxtareas];
    canttasks = 0;

}

Model &MultiCPU::externalFunction( const ExternalMessage & msg)
{
	if (msg.port() == colain)
    {
     	if (canttasks < maxtareas)			// Si la CPU no est sobrecargada
     	{
     		TaskList[canttasks].tarea = ( (union request) msg.value() );   // Agregar a la lista de tareas activas
        	TaskList[canttasks++].state = firstproccess;
            if (canttasks == maxtareas)                                  // Si se llen la lista
            {
            	estado = ack;                                       // Reconocer la recepcin
                anterior = (state() == active) ? activo : pasivo;
                TimeLeft = nextChange();                            // Guardar tiempo faltante
                holdIn(active, Time::Zero);             // Preparar para enviar aviso de lleno
            }
    	}
        else
        {
        	printf("Se llen la lista de tareas de la CPU %s", description());
            exit(1);
        }
    }

    if (msg.port() == controladorain)
    {
    	TaskList[ FindTask( ( (union request) msg.value() ) ) ].state = finalproccess;
        if (state() == passive)
        {
        	TareaActual = ( (union request) msg.value() );
            estado = activo;
            holdIn(active, Time( (float)( fabs( distribution().get() ) ) ));
        }
    }
}


Model &MultiCPU::outputFunction( const InternalMessage & msg)
{
    int tmpaddress;
    
    if(estado == ack)
    {
    	if (canttasks < maxtareas)
        	sendOutput(msg.time(), stopqueue, 1.0);
    }

    if(estado == activo)
    {
    	if(TaskList[FindTask(TareaActual)].state == firstproccess)
        {
        	sendOutput(msg.time(), controladoraout, TareaActual.f);
        }
        else
        {
        	tmpaddress = TareaActual.r.origin;
            TareaActual.r.origin = TareaActual.r.destino;
            TareaActual.r.destino = tmpaddress;
         	sendOutput(msg.time(), colaout, TareaActual.f);
            sendOutput(msg.time(), stopqueue, 1.0);
        }
    }
    return (*this);
}


Model &MultiCPU::internalFunction( const InternalMessage & msg)
{
    switch(estado)
    {
    case ack:
    	if(anterior == activo)
        {
        	estado = activo;
        	holdIn(active, TimeLeft);
        }
        else
        {
        	if(anterior == pasivo)
            {

                if(NextTask()>=0)
                {
                	TareaActual = TaskList[NextTask()].tarea;
                    estado = activo;
                    holdIn(active, Time( (float)( fabs( distribution().get() ) ) ));
                }
                else
                	passivate();
            }
        }
        break;

    case activo:
    	if (TaskList[FindTask(TareaActual)].state == firstproccess)
        	TaskList[FindTask(TareaActual)].state = diskaccess;
        else
            if (TaskList[FindTask(TareaActual)].state == finalproccess)
            {
            	RemoveTask(FindTask(TareaActual));
                if(NextTask() >= 0)
                {
                	TareaActual = TaskList[NextTask()].tarea;
                    holdIn(active, Time( (float)( fabs( distribution().get() ) ) ));
                }
                else
                	passivate();
            }
        break;

    default:
    	break;
	}

	return *this;

}
