/*******************************************************************
*
*  DESCRIPCION: clase DISCO (procesa pedidos a disco de un tamao deter-
*               minado (pasado como mensaje)
*
*  AUTORES: Ing. Carlos Giorgetti
*           Ivn Melgrati
*           Dra. Ana Rosa Tymoschuk
*
*  EMAIL: mailto://cgiorget@frsf.utn.edu.ar
*         mailto://imelgrat@frsf.utn.edu.ar
*         mailto://anrotym@alpha.arcride.edu.ar
*
*  FECHA: 09/10/1999
*
*******************************************************************/

#ifndef __DISCO_H
#define __DISCO_H

/** Archivos de Encabezado **/
#include "atomic.h"      // class Atomic
#include "mformats.h"    // formato de mensaje a pasar
#include "distri.h"        // class Distribution

/** declarations **/
class Disco: public Atomic
{
public:
	Disco( const string &name = "Disco" );          		// Constructor
	virtual ~Disco() {delete dist;}			   			// Destructor
	virtual string className() const {return "Disco";}

protected:
	Model &initFunction() {return *this;}                   // Funcin de Inicializacin

	Model &externalFunction( const ExternalMessage & );     // Funcin de Tr. Externa

	Model &internalFunction( const InternalMessage & );     // Funcin de Tr. Interna

	Model &outputFunction( const InternalMessage & );       // Funcin de Salida

private:
	const Port &in ;
	Port &out ;
	Distribution *dist ;           							// Generador de nmeros aleatorios
	union request requerimiento ;							// Requrimiento actual
    float velocidad;										// Tiempo en leer 1 KB
	Distribution &distribution(){return *dist;}
};	// class Disco


#endif   //__DISCO_H 
