/*******************************************************************
*
*  DESCRIPCION: clase CONTROLADORA (Rutea los pedidos a los Discos
*                                   y a la CPU)
*
*  AUTORES: Ing. Carlos Giorgetti
*           Ivn Melgrati
*           Dra. Ana Rosa Tymoschuk
*
*  EMAIL: mailto://cgiorget@frsf.utn.edu.ar
*         mailto://imelgrat@frsf.utn.edu.ar
*         mailto://anrotym@alpha.arcride.edu.ar
*
*  FECHA: 09/10/1999
*
*******************************************************************/


/** include files **/
#include "controla.h"       // base header
#include "message.h"       // InternalMessage ....
#include "mainsimu.h"      // class MainSimulator
#include "strutil.h"       // str2float( ... )
#include <stdlib.h>      // random() y randomize()
#include <time.h>

/*******************************************************************
* Nombre de la Funcin: Controladora::Controladora
* Descripcin: Constructor
********************************************************************/
Controladora::Controladora( const string &name ): Atomic( name ), in( addInputPort( "in" ) ), out( addOutputPort( "out" ) )
           ,discoin( addInputPort( "discoin" ) ), discoout1( addOutputPort( "discoout1" ) ), discoout2( addOutputPort( "discoout2" ) )
           , discoout3( addOutputPort( "discoout3" ) ), discoout4( addOutputPort( "discoout4" ) ), discoout5( addOutputPort( "discoout5" ) )
           , discoout6( addOutputPort( "discoout6" ) ), discoout7( addOutputPort( "discoout7" ) ), discoout8( addOutputPort( "discoout8" ) )
{
	fase = pasiva;                           // Iniciar en Estado Pasivo
    if( MainSimulator::Instance().existsParameter( description(), "discos" ) )     // Obtener la cantidad de discos (del Script .MA)
			cant = str2Int( MainSimulator::Instance().getParameter( description(), "discos" ) );
    else
			cant = 1;

    requerimiento.f = 0.0;					 // Limpiar el requerimiento actual

   	dist = Distribution::create( MainSimulator::Instance().getParameter( description(), "distribution" ) );
	for ( register int i = 0; i < dist->varCount(); i++ )
		{
			string parameter( MainSimulator::Instance().getParameter( description(), dist->getVar( i ) ) ) ;
			dist->setVar( i, str2Value( parameter ) ) ;
		}
}

/*******************************************************************
* Nombre de la Funcin: Controladora::externalFunction
* Descripcin: Se reciben peticiones desde la CPU. Elige un disco al azar y rutea la peticin
*              Si retorna una peticin, se enva a la CPU
********************************************************************/
Model &Controladora::externalFunction( const ExternalMessage &msg )
{
	if(msg.port() == in)
    	{
          fase = senddisk;
          requerimiento.f = (double) msg.value();  // Copiar datos de req.
          holdIn(active, Time::Zero);                 //Enviar al disco inmediatamente
        }
    else
    	if (msg.port() == discoin)
        {
          fase = sendCPU;
          requerimiento.f = (double) msg.value();  // Copiar datos de req.
          holdIn(active, Time::Zero);                 //Enviar a la CPU inmediatamente
        }

	return *this ;
}

/*******************************************************************
* Nombre de la Funcin: Controladora::internalFunction
* Descripcin: Se pone en estado pasivo, esperando un nuevo pedido
********************************************************************/
Model &Controladora::internalFunction( const InternalMessage & )
{
    fase = pasiva;
	passivate();
	return *this;
}

/*******************************************************************
* Nombre de la Funcin: Controladora::outputFunction
* Descripcin: Enva el trabajo a los discos o a la CPU
********************************************************************/
Model &Controladora::outputFunction( const InternalMessage &msg )
{
    int disk;
    time_t t;
    if (fase == sendCPU)
		sendOutput( msg.time(), out, requerimiento.f );
    else
        {
          srand((unsigned) time(&t));
          requerimiento.r.tamanio = (unsigned int) static_cast<float>( fabs( distribution().get() ) );
          disk = rand() % cant;
          switch(disk)
          {
           case 0:
                 sendOutput( msg.time(), discoout1, requerimiento.f );
                 break;
           case 1:
                 sendOutput( msg.time(), discoout2, requerimiento.f );
                 break;
           case 2:
                 sendOutput( msg.time(), discoout3, requerimiento.f );
                 break;
           case 3:
                 sendOutput( msg.time(), discoout4, requerimiento.f );
                 break;
           case 4:
                 sendOutput( msg.time(), discoout5, requerimiento.f );
                 break;
           case 5:
                 sendOutput( msg.time(), discoout6, requerimiento.f );
                 break;
           case 6:
                 sendOutput( msg.time(), discoout7, requerimiento.f );
                 break;
           case 7:
                 sendOutput( msg.time(), discoout8, requerimiento.f );
                 break;
           default:
           		 break;
          }
        }

	return *this;
}


