/*******************************************************************
*
*  DESCRIPCION: Client (Genera las solicitudes a los servidores)
*
*  AUTORES:
*  		   Ing. Carlos Giorgetti
*          Ivn A. Melgrati
*          Dra. Ana Rosa Tymoschuk
*
*  EMAIL: mailto://cgiorget@frsf.utn.edu.ar
*         mailto://imelgrat@frsf.utn.edu.ar
*         mailto://anrotym@alpha.arcride.edu.ar
*
*  FECHA: 19/10/1999
*
*******************************************************************/
#include <stdlib.h>
#include <time.h>
#include "client.h"
#include "message.h"
#include "mainsimu.h"
#include "strutil.h"


/*******************************************************************
* Nombre de la Funcin: Client::Client()
* Descripcin: Constructor
********************************************************************/
Client::Client( const string &name ) : Atomic( name ), out( addOutputPort( "out" ) )
{
	try
	{
        // Leer datos de la distribucin
		dist = Distribution::create( MainSimulator::Instance().getParameter( description(), "distribution" ) );
		MASSERT( dist ) ;
		for ( register int i = 0; i < dist->varCount(); i++ )
		{
			string parameter( MainSimulator::Instance().getParameter( description(), dist->getVar( i ) ) ) ;
			dist->setVar( i, str2Value( parameter ) ) ;
		}

        // Leer valor inicial del ID de la tarea
		if( MainSimulator::Instance().existsParameter( description(), "initial" ) )
			initial = str2Int( MainSimulator::Instance().getParameter( description(), "initial" ) );
		else
			initial = 0;

        // Leer valor del incremento del ID de la tarea
		if( MainSimulator::Instance().existsParameter( description(), "increment" ) )
			increment = str2Int( MainSimulator::Instance().getParameter( description(), "increment" ) );
		else
			increment = 1;

        // Leer IP Address del Cliente
		if( MainSimulator::Instance().existsParameter( description(), "address" ) )
			IPAddress = str2Int( MainSimulator::Instance().getParameter( description(), "address" ) );
		else
			IPAddress = 0;

        // Leer porcentaje de carga en el servidor 1
		if( MainSimulator::Instance().existsParameter( description(), "cargaserver1" ) )
			cargaserver1 = str2float( MainSimulator::Instance().getParameter( description(), "cargaserver1" ) );
		else
			cargaserver1 = 0.5;

	} catch( InvalidDistribution &e )
	{
		e.addText( "The model " + description() + " has distribution problems!" ) ;
		e.print(cerr);
		MTHROW( e ) ;
	} catch( MException &e )
	{
		MTHROW( e ) ;
	}
}

/*******************************************************************
* Nombre de la Funcin: Client::initFunction()
* Descripcin: Inicializa el modelo y lo pone en funcionamiento
********************************************************************/
Model &Client::initFunction()
{
    time_t t;
	pid.r.idtask = initial;                                            	// ID inicial
    pid.r.origin = IPAddress;                                          	// Direccin IP
    srand((unsigned) time(&t));
    pid.r.destino =  ((rand() % 100) > cargaserver1) ? 1 : 0;  // Server de destino
	holdIn( active, Time::Zero ) ;     					 // Programar primer envo de inmediato
	return *this ;

}

/*******************************************************************
* Nombre de la Funcin: Client::internalFunction()
* Descripcin: Programa el siguiente pedido a los servidores
********************************************************************/
Model &Client::internalFunction( const InternalMessage & )
{
	holdIn( active, Time( static_cast< float >( fabs( distribution().get() ) ) ) ) ;
	return *this ;
}

/*******************************************************************
* Nombre de la Funcin: Client::outputFunction()
* Descripcin: Enva el pedido actual y prepara el siguiente
********************************************************************/
Model &Client::outputFunction( const InternalMessage &msg )
{
	time_t t;

	sendOutput( msg.time(), out, pid.f ) ;               // Enviar peticin

	pid.r.idtask += increment;                           // Siguiente ID de tarea
    pid.r.origin = IPAddress;                            // Copiar ID Address
    srand((unsigned) time(&t));
    pid.r.destino =  ((rand() % 100) > cargaserver1) ? 1 : 0; // Servidor de destino

	return *this ;
}


