/*******************************************************************
*
*  DESCRIPTION: class Transducer (implementation)
*
*  AUTHOR: Amir Barylko & Jorge Beyoglonian 
*
*  EMAIL: mailto://amir@dc.uba.ar
*         mailto://jbeyoglo@dc.uba.ar
*
*  DATE: 27/6/1998
*
*******************************************************************/

/** include files **/
#include "transduc.h"   // base class
#include "message.h"    // class ExternalMessage 
#include "mainsimu.h"       // class MainSimulator
#include "mformats.h"
#include <stdio.h>
/*******************************************************************
* Function Name: Transducer
* Description: Constructor
********************************************************************/
Transducer::Transducer( const string &name )
: Atomic( name ) 
, arrived( addInputPort( "arrived" ) )
, solved( addInputPort( "solved" ) )
, throughput( addOutputPort( "throughput" ) )
, cpuUsage( addOutputPort( "cpuusage" ) )
, responsetime(addOutputPort( "responsetime"))
{
	frec = "0:1:0:0" ;
	tUnit = "0:1:0:0" ;

	if( MainSimulator::Instance().existsParameter( description(), "frecuence" ) )
		frec = MainSimulator::Instance().getParameter( description(), "frecuence" ) ;

	if( MainSimulator::Instance().existsParameter( description(), "timeUnit" ) )
		tUnit = MainSimulator::Instance().getParameter( description(), "timeUnit" ) ;
}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &Transducer::initFunction()
{
	procCount = 0 ;
	cpuLoad = 0 ;
	unsolved.erase( unsolved.begin(), unsolved.end() ) ;
	holdIn( active, frecuence() ) ;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
********************************************************************/
Model &Transducer::externalFunction( const ExternalMessage &msg )
{
	long id;
	union request req;
	cpuLoad += static_cast< long >( ( msg.time() - lastChange() ).asMsecs() * unsolved.size() );

	if( msg.port() == arrived )
	{
                req = (union request) msg.value();
		id = req.r.idtask * 100 + req.r.origin;		

		if( unsolved.find( id ) != unsolved.end() )
		{
			MException e( string("Unresolved Work Id: ") + (float) id + " is duplicated." );
			e.addLocation( MEXCEPTION_LOCATION() );
			throw e;
		}

		unsolved[ id ] = msg.time() ;
	}

	if( msg.port() == solved )
	{
		req = (union request) msg.value();
		id = req.r.idtask * 100 + req.r.destino;	
                
                JobsList::iterator cursor( unsolved.find( id) ) ;

		if( cursor == unsolved.end() )
		{
			MException e( string("Resolved Work Id: ") + (float) id + " Not Found!" );
			e.addLocation( MEXCEPTION_LOCATION() );
			throw e;
		}
		
		procCount ++ ;
		unsolved.erase( cursor ) ;
	}
	return *this ;
}

/*******************************************************************
* Function Name: internalFunction
********************************************************************/
Model &Transducer::internalFunction( const InternalMessage &)
{
	holdIn( active, frecuence() );
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
********************************************************************/
Model &Transducer::outputFunction( const InternalMessage &msg )
{
	float time( msg.time().asMsecs() / timeUnit().asMsecs() ) ;

	sendOutput( msg.time(), throughput, procCount / time ) ;

	cpuLoad += static_cast< long >( ( msg.time() - lastChange() ).asMsecs() * unsolved.size() ) ;

	sendOutput( msg.time(), cpuUsage  , cpuLoad / msg.time().asMsecs() ) ;
        
        sendOutput( msg.time(), responsetime, (cpuLoad / msg.time().asMsecs() ) / (procCount / time) ); 

	return *this ;
}
