/*******************************************************************
*
*  DESCRIPCION: Cola Genrica (on demand)
*
*  AUTORES:
*  		   Ing. Carlos Giorgetti
*          Ivn A. Melgrati
*          Dra. Ana Rosa Tymoschuk
*
*  EMAIL: mailto://cgiorget@frsf.utn.edu.ar
*         mailto://imelgrat@frsf.utn.edu.ar
*         mailto://anrotym@alpha.arcride.edu.ar
*
*  FECHA: 15/10/1999
*
*******************************************************************/

#include <string.h>
#include "queue.h"
#include "message.h"
#include "mainsimu.h"

/*******************************************************************
* Nombre de la Funcin: Queue::Queue()
* Descripcin: Constructor
********************************************************************/
Queue::Queue( const string &name ) : Atomic( name ), in( addInputPort( "in" ) )
, done( addInputPort( "done" ) ) , out( addOutputPort( "out" ) )
, preparationTime( 0, 0, 0, 1 )
{
	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

	if( time != "" )
		preparationTime = time ;
}


/*******************************************************************
* Nombre de la Funcin: Queue::initFunction()
* Descripcin: Funcin de Inicializacin
********************************************************************/

Model &Queue::initFunction()
{
	elements.erase( elements.begin(), elements.end() ) ;
	return *this ;
}


/*******************************************************************
* Nombre de la Funcin: Queue::externalFunction()
* Descripcin: Maneja los eventos externos (nuevas solicitudes y aviso de "listo"
********************************************************************/

Model &Queue::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == in )                             	// Si entra una nueva peticin
	{
		elements.push_back( msg.value() ) ;             // Encolarla
		if( elements.size() == 1 )                      // Si no hay otra, preparla para envo
			holdIn( active, preparationTime );
	}

	if( msg.port() == done )                            // Si notifican condicin "listo"
	{
		elements.pop_front() ;                          // Eliminar solicitud actual de cola
		if( !elements.empty() )
			holdIn( active, preparationTime );    // Programar siguiente envo
	}

	return *this;
}

/*******************************************************************
* Nombre de la Funcin: Queue::internalFunction()
* Descripcin: Pone el modelo en estado pasivo (esperando un "Done" o algo para enviar)
********************************************************************/
Model &Queue::internalFunction( const InternalMessage & )
{
	passivate();
	return *this ;
}


/*******************************************************************
* Nombre de la Funcin: Queue::outputFunction()
* Descripcin: Enva solicitud al receptor
********************************************************************/
Model &Queue::outputFunction( const InternalMessage &msg )
{
   if( !elements.empty() )   // Si la cola no est vaca, enviar primer elemento
		sendOutput( msg.time(), out, elements.front() ) ;
   return *this ;
}
