/*******************************************************************
*
*  DESCRIPCION: MultiCPU (CPU Multitarea)
*
*  AUTORES:
*  		   Ing. Carlos Giorgetti
*          Ivn A. Melgrati
*          Dra. Ana Rosa Tymoschuk
*
*  EMAIL: mailto://cgiorget@frsf.utn.edu.ar
*         mailto://imelgrat@frsf.utn.edu.ar
*         mailto://anrotym@alpha.arcride.edu.ar
*
*  FECHA: 01/04/2000
*
*******************************************************************/

#ifndef __MULTICPU_H
#define __MULTICPU_H
#include "atomic.h"
#include "mformats.h"
#include "time.h"
#include "distri.h"
#include <list.h>


typedef list<Value> Cola ;

class MultiCPU: public Atomic
{

public:
	MultiCPU( const string &name = "MultiCPU" ) ;	 // Constructor

	~MultiCPU(void){delete dist_inicial;
			delete dist_final;
                       }		   						// Destructor

	virtual string className() const  {return "MultiCPU";}

protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
    const Port &cpuin;
    const Port &controladorain;
    Port &cpuout ;
    Port &controladoraout;


    Distribution *dist_inicial, *dist_final ;		// Distribucin de probabilidad de tiempo de servicio
    Cola Proc_Inicial, Proc_Final;                      // Colas de Ejecucin
    
};	// class MultiCPU


#endif   //__MultiCPU_H
