/*******************************************************************
*
*  DESCRIPCION: MultiCPU (CPU Multitarea)
*
*  AUTORES:
*  		   Ing. Carlos Giorgetti
*          Ivn A. Melgrati
*          Dra. Ana Rosa Tymoschuk
*
*  EMAIL: mailto://cgiorget@frsf.utn.edu.ar
*         mailto://imelgrat@frsf.utn.edu.ar
*         mailto://anrotym@alpha.arcride.edu.ar
*
*  FECHA: 01/04/2000
*
*******************************************************************/

#include "multicpu.h"
#include "mainsimu.h"
#include "strutil.h"
#include "message.h"
#include "time.h"


MultiCPU::MultiCPU (const string& name): Atomic(name) , cpuin(addInputPort( "cpuin" )),
cpuout(addOutputPort("cpuout")) , controladorain(addInputPort( "controladorain" )),
controladoraout(addOutputPort("controladoraout"))
{
	// Leer datos de las distribuciones de tiempo de servicio (inicial y final)
    
    dist_inicial = Distribution::create( "normal" );
    string parameter( MainSimulator::Instance().getParameter( description(), "media_inicial" ) ) ;
    dist_inicial->setVar(0, str2Value( parameter ) ) ;
    string parameter2( MainSimulator::Instance().getParameter( description(), "desviacion_inicial" ) ) ;
    dist_inicial->setVar(1, str2Value( parameter2 ) ) ;


    dist_final = Distribution::create( "normal");
    string parameter3( MainSimulator::Instance().getParameter( description(), "media_final" ) ) ;
    dist_final->setVar(0, str2Value( parameter3 ) ) ;
    string parameter4( MainSimulator::Instance().getParameter( description(), "desviacion_final" ) ) ;
    dist_final->setVar(1, str2Value( parameter4 ) ) ;
}

Model &MultiCPU::initFunction()
{
	Proc_Inicial.erase (Proc_Inicial.begin(), Proc_Inicial.end());
	Proc_Final.erase (Proc_Final.begin(), Proc_Final.end());
	return *this;
}



Model &MultiCPU::externalFunction( const ExternalMessage & msg)
{

    if(msg.port() == cpuin)
    {
	Proc_Inicial.push_back(msg.value());
    }
    
    if(msg.port() == controladorain)
    {
       Proc_Final.push_back(msg.value());
    }
    
    if(state() == passive)
    {	if(!Proc_Final.empty())
	{
		holdIn(active, dist_final->get());
	}
        else
	{	
		holdIn(active, dist_inicial->get());
	}
    }

    return (*this);
}


Model &MultiCPU::outputFunction( const InternalMessage & msg)
{
    union request req;
    int tmp;

    if(state() == active)
    {
	if(!Proc_Final.empty())
	{	
		req = (union request) Proc_Final.front();
		tmp = req.r.origin;
		req.r.origin = req.r.destino;
		req.r.destino = tmp;
                sendOutput(msg.time(), cpuout, req.f);
	}
	else
		{if(!Proc_Inicial.empty())
		{	
			req = (union request) Proc_Inicial.front();
                        sendOutput(msg.time(), controladoraout, req.f);
		}	
	}
    }
    return (*this);
}


Model &MultiCPU::internalFunction( const InternalMessage & msg)
{

	
	if (!Proc_Final.empty())
		{
			Proc_Final.pop_front();
			
		}
	else
		if (!Proc_Inicial.empty())
		{
			Proc_Inicial.pop_front();
		}
	
	if(!Proc_Final.empty())
	{	
		holdIn(active, dist_final->get());
	}
	else
	{
		if(!Proc_Inicial.empty())
		{
			holdIn(active, dist_inicial->get());
		} 
		else
		{
			passivate();
		}
	}
	return *this;

}
