/*******************************************************************
*
*  DESCRIPCION: Client (Genera las solicitudes a los servidores)
*
*  AUTORES:
*  		   Ing. Carlos Giorgetti
*          Ivn A. Melgrati
*          Dra. Ana Rosa Tymoschuk
*
*  EMAIL: mailto://cgiorget@frsf.utn.edu.ar
*         mailto://imelgrat@frsf.utn.edu.ar
*         mailto://anrotym@alpha.arcride.edu.ar
*
*  FECHA: 19/10/1999
*
*******************************************************************/
#ifndef __CLIENT_H
#define __CLIENT_H
#include "atomic.h"
#include "except.h"
#include "mformats.h"
#include "distri.h"

class Client : public Atomic
{
public:
	Client( const string &name = "Client" );				  // Default constructor

	virtual ~Client(){delete dist;}

	virtual string className() const  {return "Client";}

protected:
	Model &initFunction() ;

	Model &externalFunction( const ExternalMessage & )    // No puede recibir mensajes
    	{throw InvalidMessageException();}                // ya que no tiene entradas

	Model &internalFunction( const InternalMessage & );

	Model &outputFunction( const InternalMessage & );

private:
	union request pid;
	int initial, increment;
    float cargaserver1;
    int IPAddress;
	Port &out ;
	Distribution *dist;

	Distribution &distribution(){return *dist;}
			
};	// class Client


#endif   //__CLIENT_H
