/*******************************************************************
*
*  DESCRIPCION: Client (Genera las solicitudes a los servidores)
*
*  AUTORES:
*  		   Ing. Carlos Giorgetti
*          Ivn A. Melgrati
*          Dra. Ana Rosa Tymoschuk
*
*  EMAIL: mailto://cgiorget@frsf.utn.edu.ar
*         mailto://imelgrat@frsf.utn.edu.ar
*         mailto://anrotym@alpha.arcride.edu.ar
*
*  FECHA: 19/10/1999
*
*******************************************************************/
#include <stdlib.h>
//#include <time.h>
#include "C:\cygwin\usr\include\time.h"
#include "client.h"
#include "message.h"
#include "mainsimu.h"
#include "strutil.h"
#include <stdio.h>


// ** main ** //
static const unsigned long unifc = 1234567891;  // Estos son los valores de la
static const unsigned long unifa = 2564393833;  // sucesion lineal congruencial
static const unsigned long unifm = 2147483648;  // POTENCIA = 11
static unsigned long unifx0=0;                  // Semilla de nuestra suc.lineal

static unsigned	long	cant0 = 0;
static unsigned long	cant1 = 0;

/*******************************************************************
* Nombre de la Funcin: Uniforme()
* Descripcin: Genera nmeros al azar entre 0 y 1 con distribucin uniforme
********************************************************************/
double Uniforme(void)   // Devuelve un numero al azar segun una
{                       // distribucion uniforme, comprendido entre
                        // 0 y 1 (Nunca alcanza 1, o sea 0<=x<1 )
        time_t tiempo;

        if (unifx0 == 0)
                unifx0 = clock()+time(&tiempo);
        else
                unifx0 = (unifa*unifx0+unifc) % unifm;

        return ((double) unifx0) / ((double) unifm);
}
/*******************************************************************
* Nombre de la Funcin: Client::Client()
* Descripcin: Constructor
********************************************************************/
Client::Client( const string &name ) : Atomic( name ), out( addOutputPort( "out" ) )
{
	try
	{
        // Leer datos de la distribucin
		dist = Distribution::create( MainSimulator::Instance().getParameter( description(), "distribution" ) );
		MASSERT( dist ) ;
		for ( register int i = 0; i < dist->varCount(); i++ )
		{
			string parameter( MainSimulator::Instance().getParameter( description(), dist->getVar( i ) ) ) ;
			dist->setVar( i, str2Value( parameter ) ) ;
		}
                

        // Leer valor inicial del ID de la tarea
		if( MainSimulator::Instance().existsParameter( description(), "initial" ) )
			initial = str2Int( MainSimulator::Instance().getParameter( description(), "initial" ) );
		else
			initial = 0;

        // Leer valor del incremento del ID de la tarea
		if( MainSimulator::Instance().existsParameter( description(), "increment" ) )
			increment = str2Int( MainSimulator::Instance().getParameter( description(), "increment" ) );
		else
			increment = 1;

        // Leer IP Address del Cliente
		if( MainSimulator::Instance().existsParameter( description(), "address" ) )
			IPAddress = str2Int( MainSimulator::Instance().getParameter( description(), "address" ) );
		else
			IPAddress = 0;

        // Leer porcentaje de carga en el servidor 1
		if( MainSimulator::Instance().existsParameter( description(), "cargaserver1" ) )
			cargaserver1 = str2float( MainSimulator::Instance().getParameter( description(), "cargaserver1" ) );
		else
			cargaserver1 = 0.5;

	} catch( InvalidDistribution &e )
	{
		e.addText( "The model " + description() + " has distribution problems!" ) ;
		e.print(cerr);
		MTHROW( e ) ;
	} catch( MException &e )
	{
		MTHROW( e ) ;
	}
}

/*******************************************************************
* Nombre de la Funcin: Client::initFunction()
* Descripcin: Inicializa el modelo y lo pone en funcionamiento
********************************************************************/
Model &Client::initFunction()
{
    double f;
    time_t t;
    pid.r.idtask = initial;                                            	// ID inicial
    pid.r.origin = IPAddress;				    // Direccin IP
    srand((unsigned) time(&t));
    f= Uniforme();
    pid.r.destino =  ( f > cargaserver1 ) ? 1 : 0; // Servidor de destino
	holdIn( active, Time::Zero ) ;     					 // Programar primer envo de inmediato
	return *this ;

}

/*******************************************************************
* Nombre de la Funcin: Client::internalFunction()
* Descripcin: Programa el siguiente pedido a los servidores
********************************************************************/
Model &Client::internalFunction( const InternalMessage & )
{
	holdIn( active, Time( static_cast< float >( fabs( distribution().get() ) ) ) ) ;
	return *this ;
}

/*******************************************************************
* Nombre de la Funcin: Client::outputFunction()
* Descripcin: Enva el pedido actual y prepara el siguiente
********************************************************************/
Model &Client::outputFunction( const InternalMessage &msg )
{
    time_t t;
    double f;
    pid.r.idtask += increment;                           // Siguiente ID de tarea
    pid.r.origin = IPAddress;                            // Copiar ID Address
    srand((unsigned) time(&t));
    f= Uniforme();
    pid.r.destino =  ( f > cargaserver1 ) ? 1 : 0; // Servidor de destino
    sendOutput( msg.time(), out, pid.f ) ;               // Enviar peticin
    
    
    return *this ;
}


