
#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <fstream>
#include <math.h>
#include <sstream>

using namespace std;
    
#define ROW 10
#define COL 10 			//Column
#define NUM_PLANE 3		//Movement, Food, Direction
#define NUM_FOOD 99

//Plane 1: if cell value = 0, then there is No worm in this cell. If 0 < cell value < 100 , then there is a worm in this cell.
//Plane 2: if cell value = 0, then there is No Food in this cell. If cell value = 600, then there is Food in this cell.
//Plane 3: if cell value = 500, then do not move.
//		   if cell value = 501, then move to the North
//		   if cell value = 502, then move to the South
//		   if cell value = 503, then move to the East
//		   if cell value = 504, then move to the West


ofstream createVal;
ofstream createValTables;

int main(){

	double cell [NUM_PLANE][ROW][COL];
	int temp,tempRow,tempCol;
	int foodCounter = 0;
	
	for (int k = 0; k < NUM_PLANE; k++){
        for (int i = 0; i < ROW; i++){
            for (int j = 0; j < COL; j++){
            	if(k==0){
            		cell[k][i][j] = 0;
				}				
				else if(k==1){
					temp = rand() % 5;
					if(temp==4 && foodCounter < NUM_FOOD + 1){
						cell[k][i][j] = 600;
						foodCounter ++;						
					}else cell[k][i][j] = 0;
				}
				else if(k==2){
					cell[k][i][j] = 0;
				}		        	
            }
        }
    }
    
    //Make sure that one of the cells in the plane one has the WORM.
    tempRow = rand() % ROW;
    tempCol = rand() % COL;
    cell[0][tempRow][tempCol] = 1;
    cell[1][tempRow][tempCol] = 0;	//Make sure that the correspondent cell in plane 1 does not have food.
    cell[2][tempRow][tempCol] = (rand() % 5) + 500;;	//Make sure that the correspondent cell in plane 2 has the next move direction.
    
	//open files to write in them
	std::ostringstream oss;
    oss << "worm.val";
    createVal.open(oss.str().c_str(), ios::out);
    oss.str("");
    oss << "worm.txt";
    createValTables.open(oss.str().c_str(), ios::out);
    
	//start to write into the file
	if (createVal == NULL) {
	   cout<< "*** The worm.val file has not been created. ***" << endl;
	}
	else{
		for (int k = 0; k < NUM_PLANE; k++){
        	for (int i = 0; i < ROW; i++){
            	for (int j = 0; j < COL; j++){            		
            		 createVal << "(" << i << "," << j << "," << k << ") = " << cell[k][i][j] << endl;
                 }           
             }
         }	
         createVal.close();
 	}//end of else
   	//start to write into the file
	if (createValTables == NULL) {
	   cout<< "*** The testValues.txt file has not been created. ***" << endl;
	}
	else{
         for (int k = 0; k < NUM_PLANE; k++){
             for (int i = 0; i < ROW; i++){
                 for (int j = 0; j < COL; j++){
                     if(cell[k][i][j] < 10  ) createValTables << cell[k][i][j] << "   ";
                     else if(cell[k][i][j] < 100 ) createValTables << cell[k][i][j] << "  ";
                     else createValTables << cell[k][i][j] << " ";
                 }           
             createValTables << endl;
             }
         createValTables << endl << endl << endl;
         }	
         createValTables.close();
 	}//end of else 
}//END OF MAIN
