
/*
*metodos.cpp
*
*/

#include <iostream>
#include <fstream>
#include <iosfwd>

#include "gdal.h"
#include "gdal_priv.h"
#include "cpl_conv.h"

#include "metodos.h"
#include "utils.h"
#define __DEBUG 0

using namespace std;

int metodo1(GDALDataset * poDataset, ofstream &fileVal) {
	
	int cantidadDeBandas = poDataset->GetRasterCount();

	int * tamanoX=new int[cantidadDeBandas];
	int * tamanoY=new int[cantidadDeBandas];
	int tamanoMaxX = 0, tamanoMaxY = 0;

	
	for (int nBanda=1; nBanda<=cantidadDeBandas; nBanda++) {

		GDALRasterBand *banda = poDataset->GetRasterBand( nBanda );

		tamanoX[nBanda-1] = banda->GetXSize();
		tamanoMaxX = MAX(tamanoMaxX,tamanoX[nBanda-1]);

		tamanoY[nBanda-1] = banda->GetYSize();
		tamanoMaxY = MAX(tamanoMaxY,tamanoY[nBanda-1]);

		if (__DEBUG) cout << "Band " << nBanda << ": " << tamanoX[nBanda-1] << " X " << tamanoY[nBanda-1] << endl;

	}

	for (int nBanda=1; nBanda<=cantidadDeBandas; nBanda++) {
		GDALRasterBand *banda = poDataset->GetRasterBand( nBanda );

		if (__DEBUG) {
			cout << endl;
			cout << "Working with the band:  " << nBanda << endl;
		}

		int blockX, blockY;
		banda->GetBlockSize(&blockX, &blockY);
		if (__DEBUG) {
			cout << "Band " << nBanda << ": " << tamanoX[nBanda-1] << " X " << tamanoY[nBanda-1] << endl;
			cout << "\tBlock X: " << blockX << " Block Y: " << blockY << endl;
		}

		GDALDataType tipoDato = banda->GetRasterDataType();
		if (__DEBUG) {
			cout << "\tType of Data: " << tipoDato << " ("<< GDALGetDataTypeName(tipoDato) << ")" << endl;
		}
		
		float* datosMapa = (float *) CPLMalloc(sizeof(float)*blockX*blockY);
		 
		if (datosMapa==NULL) {
		  cout<<"Error creating the array! \n";
		}
		if (__DEBUG) {
			cout << endl;
			cout << "Creatign details map array. size (data x blockX x blockY): " << sizeof(float) << " X " << blockX << " X " << blockY << " = " << sizeof(float)*blockX*blockY << endl;
		}

	     int        nXBlocks, nYBlocks, nXBlockSize, nYBlockSize;
	     int        iXBlock, iYBlock;
	     GByte      *pabyData;

		 banda->GetBlockSize( &nXBlockSize, &nYBlockSize );
		 cout<<"nxblocksize"<<nXBlockSize<<endl;
		 cout<<"nyblocksize"<<nYBlockSize<<endl;
		 pabyData = (GByte *) CPLMalloc(sizeof(GByte) * nXBlockSize * nYBlockSize);

	     nXBlocks = (banda->GetXSize() + nXBlockSize - 1) / nXBlockSize;
	     nYBlocks = (banda->GetYSize() + nYBlockSize - 1) / nYBlockSize;


	     for( iYBlock = 0; iYBlock < nYBlocks; iYBlock++ )
	     {
	         for( iXBlock = 0; iXBlock < nXBlocks; iXBlock++ )
	         {
	        	  int        nXValid, nYValid;
				  banda->ReadBlock( iXBlock, iYBlock, pabyData );

				  if( (iXBlock+1) * nXBlockSize > banda->GetXSize() )
					  nXValid = banda->GetXSize() - iXBlock * nXBlockSize;
				  else
					  nXValid = nXBlockSize;

				  if( (iYBlock+1) * nYBlockSize > banda->GetYSize() )
					  nYValid = banda->GetYSize() - iYBlock * nYBlockSize;
				  else
					  nYValid = nYBlockSize;

				  grabarEnArchivoVal(fileVal,
								   tamanoX[nBanda-1], tamanoY[nBanda-1], cantidadDeBandas,
								   nBanda-1,
								   //datosMapa, GDT_Float32,
								pabyData, GDT_Byte,
								   iXBlock*blockX, iYBlock*blockY, //starting coordinate of block visiting
								   nXValid, nYValid); //valid block size
	         }
	     }

	}

	return 0;
}
