
/*
*utils.cpp
*
*/
#include <iostream>
#include <fstream>
#include <iosfwd>

#include <stdio.h>
#include <stdlib.h>

#include "utils.h"
#include "gdal_priv.h"

#define __DEBUG 0



#define TAM_LINEA 256
#define error_fatal 255
using namespace std;

void grabarEnArchivoVal(ofstream &fileVal,
						int dimX, int dimY, int dimZ,
						int nivel,
						GByte *datos, GDALDataType tipoDato,
						int inicioX, int inicioY, 				
						int nXValid, int nYValid) { 			
	
	char *tipoDatoStr =  (char*) GDALGetDataTypeName(tipoDato);
	
	char formato[256];
	if (strcmp(tipoDatoStr,"Float32")==0){
		
		strcpy(formato,"(%d, %d, %d)=%.2f");
	} else if (strcmp(tipoDatoStr,"Byte")==0){
		strcpy(formato, "(%d, %d, %d)=%.2f");
	} else {
		strcpy(formato, "(%d, %d, %d)=%u");
	}

	
	if (inicioX<0 || inicioY<0 || nXValid<0 || nYValid<0 || fileVal==NULL) {
		return;
	}
	if ( ! (inicioX+nXValid<=dimX && inicioY+nYValid<=dimY && nivel<=dimZ)) {
		return;
	}

	char linea[TAM_LINEA];
	int _saltoX = 10000, _saltoY = 100;

	for (int y=0; y<nYValid; y++) {
		
		for (int x=0; x<nXValid; x++) {

			strcpy(linea, "");
			float valor = 1.0*datos[x+y*nXValid];  //get each pixel
			sprintf(linea, formato, inicioY + y, inicioX + x, nivel, valor);
		
			fileVal << linea << endl;
			
		}
	}

}

