package alansgraph;

import edu.uci.ics.jung.algorithms.layout.SpringLayout.LengthFunction;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;

public class P2PNetEdgeLengthFunction implements LengthFunction<Number> {

	Graph<P2PVertex,Number> mygraph;
	
	public P2PNetEdgeLengthFunction(Graph<P2PVertex,Number> graph){
	mygraph = graph;	
	}
	
	@Override
	public double getLength(Number edge) {
		// TODO Auto-generated method stub
		Pair<P2PVertex> nodes = mygraph.getEndpoints(edge);
		P2PVertex firstNode = nodes.getFirst();
		P2PVertex sndNode = nodes.getSecond();
		if( firstNode.isPeer() && sndNode.isPeer())
			return 75; //distance between two peers
		else
			return 20; //distance between a peer and a document
	}

}
