/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.local;

import com.noelios.restlet.ClientHelper;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.data.CharacterSet;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Request;
import org.restlet.resource.Variant;
import org.restlet.service.MetadataService;

public class LocalClientHelper
extends ClientHelper {
    public LocalClientHelper(Client client) {
        super(client);
    }

    public String getDefaultLanguage() {
        return this.getHelpedParameters().getFirstValue("defaultLanguage", "");
    }

    public MetadataService getMetadataService(Request request) {
        MetadataService result = null;
        Application application = Application.getCurrent();
        if (application != null) {
            result = application.getMetadataService();
        } else {
            result = new MetadataService();
            result.setDefaultLanguage(Language.valueOf(this.getDefaultLanguage()));
        }
        return result;
    }

    public int getTimeToLive() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("timeToLive", "600"));
    }

    public void updateMetadata(MetadataService metadataService, String entryName, Variant variant) {
        if (variant != null) {
            MediaType defaultMediaType;
            Language defaultLanguage;
            String[] tokens = entryName.split("\\.");
            for (int j = 1; j < tokens.length; ++j) {
                String primaryPart;
                int dashIndex;
                Metadata current = metadataService.getMetadata(tokens[j]);
                if (current != null) {
                    if (current instanceof MediaType) {
                        variant.setMediaType((MediaType)current);
                    } else if (current instanceof CharacterSet) {
                        variant.setCharacterSet((CharacterSet)current);
                    } else if (current instanceof Encoding) {
                        variant.getEncodings().add((Encoding)current);
                    } else if (current instanceof Language) {
                        variant.getLanguages().add((Language)current);
                    }
                }
                if ((dashIndex = tokens[j].indexOf(45)) == -1 || !((current = metadataService.getMetadata(primaryPart = tokens[j].substring(0, dashIndex))) instanceof Language)) continue;
                variant.getLanguages().add((Language)current);
            }
            if (variant.getLanguages().isEmpty() && (defaultLanguage = metadataService.getDefaultLanguage()) != null && !defaultLanguage.equals(Language.ALL)) {
                variant.getLanguages().add(defaultLanguage);
            }
            if (variant.getMediaType() == null && (defaultMediaType = metadataService.getDefaultMediaType()) != null && !defaultMediaType.equals(MediaType.ALL)) {
                variant.setMediaType(defaultMediaType);
            }
        }
    }
}

