/*******************************************************************
*
*  DESCRIPTION: Atomic Model WAN Switch
*
*  AUTHOR: Aizaz Chaudhry
*
*  EMAIL: mailto://auhchaud@sce.carleton.ca
*
*  DATE: 08/02/2011
*
*******************************************************************/

/** include files **/
#include "WANswitch.h"      // class WANSwitch
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )


/** public functions **/

/*******************************************************************
* Function Name: WAN Switch
* Description:
********************************************************************/
WANSwitch::WANSwitch( const string &name )
: Atomic( name )
, switchIn( addInputPort( "switchIn" ) )
, switchOut1( addOutputPort( "switchOut1" ) )
, switchOut2( addOutputPort( "switchOut2" ) )
, switchOut3( addOutputPort( "switchOut3" ) )
, packetsDropped( addOutputPort( "packetsDropped" ) )
, preparationTime( 0, 0, 1, 0 )
{	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

	if( time != "" )
		preparationTime = time ;

	string ws1( MainSimulator::Instance().getParameter( description(), "A" ) ) ;
	A = str2float( ws1 ) ;

	string ws2( MainSimulator::Instance().getParameter( description(), "B" ) ) ;
	B = str2float( ws2 ) ;

	string ws3( MainSimulator::Instance().getParameter( description(), "C" ) ) ;
	C = str2float( ws3 ) ;

	string ws4( MainSimulator::Instance().getParameter( description(), "D" ) ) ;
	D = str2float( ws4 ) ;

	string ws5( MainSimulator::Instance().getParameter( description(), "E" ) ) ;
	E = str2float( ws5 ) ;

	string ws6( MainSimulator::Instance().getParameter( description(), "F" ) ) ;
	F = str2float( ws6 ) ;

	string ws7( MainSimulator::Instance().getParameter( description(), "G" ) ) ;
	G = str2float( ws7 ) ;

	string ws8( MainSimulator::Instance().getParameter( description(), "H" ) ) ;
	H = str2float( ws8 ) ;

	string ws9( MainSimulator::Instance().getParameter( description(), "I" ) ) ;
	I = str2float( ws9 ) ;
}

/*******************************************************************
* Function Name: initFunction
* Description:
********************************************************************/
Model &WANSwitch::initFunction()
{
	this-> passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &WANSwitch::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == switchIn )
	{
		destAddr = static_cast < int > (msg.value());
		holdIn(active, preparationTime );
	}
	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &WANSwitch::internalFunction( const InternalMessage & )
{
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &WANSwitch::outputFunction( const InternalMessage &msg )
{
	if ( destAddr == A || destAddr == B || destAddr == C )
	{
		sendOutput( msg.time(), switchOut1, destAddr ) ;
	}
	else if (destAddr == D || destAddr == E || destAddr == F )
	{
		sendOutput( msg.time(), switchOut2, destAddr ) ;
	}
	else if (destAddr == G || destAddr == H || destAddr == I )
	{
		sendOutput( msg.time(), switchOut3, destAddr ) ;
	}
	else
	{
		sendOutput( msg.time(), packetsDropped, destAddr ) ;
	}
	return *this ;
}
