/*******************************************************************
*
*  DESCRIPTION: Atomic Model WAN Switch
*
*  AUTHOR: Aizaz Chaudhry
*
*  EMAIL: mailto://auhchaud@sce.carleton.ca
*
*  DATE: 08/02/2011
*
*******************************************************************/

#ifndef __WANSWITCH_H
#define __WANSWITCH_H


#include "atomic.h"     // class Atomic

class WANSwitch : public Atomic
{
public:
	WANSwitch( const string &name = "WANSwitch" );					//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &switchIn;
	Port &switchOut1;
	Port &switchOut2;
	Port &switchOut3;
	Port &packetsDropped;
	Time preparationTime;
	int destAddr;
	int A;
	int B;
	int C;
	int D;
	int E;
	int F;
	int G;
	int H;
	int I;
};	// class WANSwitch

// ** inline ** //
inline
string WANSwitch::className() const
{
	return "WANSwitch" ;
}

#endif   //__WANSWITCH_H
