/*******************************************************************
*
*  DESCRIPTION: Atomic Model LAN Switch
*
*  AUTHOR: Aizaz Chaudhry
*
*  EMAIL: mailto://auhchaud@sce.carleton.ca
*
*  DATE: 08/02/2011
*
*******************************************************************/

#ifndef __LANSWITCH_H
#define __LANSWITCH_H


#include "atomic.h"     // class Atomic

class LANSwitch : public Atomic
{
public:
	LANSwitch( const string &name = "LANSwitch" );					//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &switchIn;
	Port &switchOut1;
	Port &switchOut2;
	Port &switchOut3;
	Port &gateWay;
	Time preparationTime;
	int destAddr;
	int workstationOneAddr;
	int workstationTwoAddr;
	int workstationThreeAddr;
};	// class LANSwitch

// ** inline ** //
inline
string LANSwitch::className() const
{
	return "LANSwitch" ;
}

#endif   //__LANSWITCH_H
