/*******************************************************************
*
*  DESCRIPTION: Atomic Model LAN Switch
*
*  AUTHOR: Aizaz Chaudhry
*
*  EMAIL: mailto://auhchaud@sce.carleton.ca
*
*  DATE: 08/02/2011
*
*******************************************************************/

/** include files **/
#include "LANswitch.h"      // class LANSwitch
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )


/** public functions **/

/*******************************************************************
* Function Name: LAN Switch
* Description:
********************************************************************/
LANSwitch::LANSwitch( const string &name )
: Atomic( name )
, switchIn( addInputPort( "switchIn" ) )
, switchOut1( addOutputPort( "switchOut1" ) )
, switchOut2( addOutputPort( "switchOut2" ) )
, switchOut3( addOutputPort( "switchOut3" ) )
, gateWay( addOutputPort( "gateWay" ) )
, preparationTime( 0, 0, 1, 0 )
{	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

	if( time != "" )
		preparationTime = time ;

	string ws1( MainSimulator::Instance().getParameter( description(), "workstationOneAddress" ) ) ;
	workstationOneAddr = str2float( ws1 ) ;

	string ws2( MainSimulator::Instance().getParameter( description(), "workstationTwoAddress" ) ) ;
	workstationTwoAddr = str2float( ws2 ) ;

	string ws3( MainSimulator::Instance().getParameter( description(), "workstationThreeAddress" ) ) ;
	workstationThreeAddr = str2float( ws3 ) ;
}

/*******************************************************************
* Function Name: initFunction
* Description:
********************************************************************/
Model &LANSwitch::initFunction()
{
	this-> passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &LANSwitch::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == switchIn )
	{
		destAddr = static_cast < int > (msg.value());
		holdIn(active, preparationTime );
	}
	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &LANSwitch::internalFunction( const InternalMessage & )
{
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &LANSwitch::outputFunction( const InternalMessage &msg )
{
	if ( destAddr == workstationOneAddr )
	{
		sendOutput( msg.time(), switchOut1, destAddr ) ;
	}
	else if (destAddr == workstationTwoAddr )
	{
		sendOutput( msg.time(), switchOut2, destAddr ) ;
	}
	else if (destAddr == workstationThreeAddr )
	{
		sendOutput( msg.time(), switchOut3, destAddr ) ;
	}
	else
	{
		sendOutput( msg.time(), gateWay, destAddr ) ;
	}
	return *this ;
}
