/*******************************************************************
*
*  DESCRIPTION: Atomic Model Walkway
*
*  AUTHOR: Talal Bin Qamar
*
*  EMAIL: mailto://talalqamar@cmail.carleton.ca
*
*  DATE: 3/9/2016
*
*******************************************************************/

#ifndef __WALKWAY_H
#define __WALKWAY_H

#include "atomic.h"     // class Atomic


/** forward declarations **/
class Distribution ;

class Walkway : public Atomic
{
public:
	Walkway( const string &name = "Walkway" );				//Default constructor
	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &passiveMelt;
	const Port &snow;
	const Port &vehicle1;  // normal snow clearing vehicle
	const Port &vehicle2;  // normal snow removing vehicle (truck)
	Port &snowAccOn;
	Port &snowAccSide;
	Time clearingTimeOn;
	Time clearingTimeSide;
	int snowOn; // snow on the walkway
	int snowSide; // snow on the side of the walkway
	bool onVehicle;
	bool sideVehicle;

};	// class Walkway

// ** inline ** //
inline
string Walkway::className() const
{
	return "Walkway" ;
}

#endif   //__WALKWAY_H
