/*******************************************************************
*
*  DESCRIPTION: Atomic Model TailDetection
*
*  AUTHOR: Guillaume Plouffe
*
*  EMAIL: mailto://gplou010@uottawa.ca
*
*  DATE: 04/03/2016
*
*******************************************************************/

#ifndef __TailDetection_H
#define __TailDetection_H

/** include files **/
#include "atomic.h"  // class Atomic

/** forward declarations **/
class Distribution ;

/** declarations **/
class TailDetection: public Atomic
{
public:
	TailDetection( const string &name = "TailDetection" ) ;	 // Default constructor
	~TailDetection();					// Destructor
	virtual string className() const
		{return "TailDetection";}

protected:
	Model &initFunction();	
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:

	//inputs
	const Port &startIn;
	const Port &speedIn;



	//outputs
	Port &scanStop;
	Port &done;
	Port &lengthOut;

	// Variables
	bool isScanOver;
	float distFromScanner;
	float distScannerFromBin;
	float speed;
	float length;


	Distribution * dist;

	Distribution &distribution()
			{return *dist;}


};	 //class TailDetection


#endif   //__TailDetection_H
