/*******************************************************************
*
*  DESCRIPTION: Atomic Model HeadDetection
*
*  AUTHOR: Guillaume Plouffe
*
*  EMAIL: mailto://gplou010@uottawa.ca
*
*  DATE: 04/03/2016
*
*******************************************************************/

#ifndef __HeadDetection_H
#define __HeadDetection_H

/** include files **/
#include "atomic.h"  // class Atomic

/** forward declarations **/
class Distribution ;

/** declarations **/
class HeadDetection: public Atomic
{
public:
	HeadDetection( const string &name = "HeadDetection" ) ;	 // Default constructor
	~HeadDetection();					// Destructor
	virtual string className() const
		{return "HeadDetection";}

protected:
	Model &initFunction();	
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	//inputs
	const Port &productIn;
	const Port &speedIn;

	//outputs
	Port &scanStart;
	Port &out;

	// Variables
	float distFromScanner;
	float speed;

	Distribution * dist;

	Distribution &distribution()
			{return *dist;}


};	 //class HeadDetection


#endif   //__HeadDetection_H
