/*******************************************************************
*
*  DESCRIPTION: Atomic Model Scanner
*
*  AUTHOR: Guillaume Plouffe
*
*  EMAIL: mailto://gplou010@uottawa.ca
*
*  DATE: 04/03/2016
*
*******************************************************************/

#ifndef __Scanner_H
#define __Scanner_H

/** include files **/
#include "atomic.h"  // class Atomic

/** forward declarations **/
class Distribution ;

/** declarations **/
class Scanner: public Atomic
{
public:
	Scanner( const string &name = "Scanner" ) ;	 // Default constructor
	~Scanner();					// Destructor
	virtual string className() const
		{return "Scanner";}

protected:
	Model &initFunction();	
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	//inputs
	const Port &startIn;
	const Port &stopIn;

	//outputs
	Port &resultOut;

	// Variables
	Distribution * dist;
	float startTime;
	float stopTime;
	int scanResult;
	float distributionValue;

	Distribution &distribution()
			{return *dist;}

};	 //class Scanner


#endif   //__Scanner_H
