/*******************************************************************
*


*
*******************************************************************/

/** include files **/
#include "receiveH.h"      // class Queue
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )

/** public functions **/

/*******************************************************************
* Function Name: Receive
* Description:
********************************************************************/
receiveH::receiveH( const string &name )
: Atomic( name )
, pkt_high_rec ( addInputPort( "pkt_high_rec" ) )
, packet_outh_n( addOutputPort( "packet_outh_n" ) )
, ack_h( addOutputPort( "ack_h" ) )
, done_h( addOutputPort( "done_h" ) )
, preparationTime( 0, 0, 10, 0 )
{
	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

	if( time != "" )
		preparationTime = time ;
}

/*******************************************************************
* Function Name: initFunction
* Description: Resetea la lista
* Precondition: El tiempo del proximo evento interno es Infinito
********************************************************************/
Model &receiveH::initFunction()
{
	this-> passivate();
	acko = 0;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &receiveH::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == pkt_high_rec )
	{
		packet_out = static_cast < int > (msg.value());
		cout<<"value of packet"<<packet_out<<"\n";
		acko = acko + 1;
		done = 1;
		cout<<"ack is"<<acko<<"\n";
		sending = true;
		holdIn( active, preparationTime );
	}

	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &receiveH::internalFunction( const InternalMessage & )
{
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &receiveH::outputFunction( const InternalMessage &msg )
{
	if (sending)
	{
	sendOutput( msg.time(), ack_h, acko) ;
	cout<<"ack is"<<acko<<"\n";
	sendOutput( msg.time(), packet_outh_n, packet_out );
	cout<<"output is "<<packet_out<<"\n";
	sendOutput( msg.time(), done_h, done );

	}
	return *this ;
}

