/*******************************************************************
*


*
*******************************************************************/

/** include files **/
#include "receiveL.h"      // class Queue
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )

/** public functions **/

/*******************************************************************
* Function Name: Receive
* Description:
********************************************************************/
receiveL::receiveL( const string &name )
: Atomic( name )
, pkt_low_rec ( addInputPort( "pkt_low_rec" ) )
, packet_outl_n( addOutputPort( "packet_outl_n" ) )
//, ack_l( addOutputPort( "ack_l" ) )
, done_l( addOutputPort( "done_l" ) )
, preparationTime( 0, 0, 10, 0 )
{
	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

	if( time != "" )
		preparationTime = time ;
}

/*******************************************************************
* Function Name: initFunction
* Description: Resetea la lista
* Precondition: El tiempo del proximo evento interno es Infinito
********************************************************************/
Model &receiveL::initFunction()
{
	this-> passivate();
	acko = 0;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &receiveL::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == pkt_low_rec )
	{
		packet_out = static_cast < int > (msg.value());
		cout<<"value of packet"<<packet_out<<"\n";
		acko = acko + 1;
		done = 1;
		cout<<"ack is"<<acko<<"\n";
		sending = true;
		holdIn( active, preparationTime );
	}

	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &receiveL::internalFunction( const InternalMessage & )
{
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &receiveL::outputFunction( const InternalMessage &msg )
{
	if (sending)
	{
	//sendOutput( msg.time(), ack_l, acko) ;
	//cout<<"ack is"<<acko<<"\n";
	sendOutput( msg.time(), packet_outl_n, packet_out );
	cout<<"output is "<<packet_out<<"\n";
	sendOutput( msg.time(), done_l, done );

	}
	return *this ;
}

