/*******************************************************************
*
*  DESCRIPTION:
*
*  AUTHOR:
*
*  EMAIL:
*
*  DATE:
*
*******************************************************************/

/** include files **/
#include "timer.h"      // class Timer
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )

/** public functions **/

/*******************************************************************
* Function Name:
* Description:
********************************************************************/
Timer::Timer( const string &name )
: Atomic( name )
, update( addInputPort( "update" ) )
, aisleOpen( addOutputPort( "aisleOpen" ) )
, walk_in( addOutputPort( "walk_in" ) )
, preparationTime( 0, 0,15, 0 )
, doorTime(0, 0, 10, 0)

{
}

/*******************************************************************
* Function Name: initFunction
* Description:
* Precondition:
********************************************************************/
Model &Timer::initFunction()
{
	holdIn( passive, Time::Zero );
	ifaisleOpen = false ;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &Timer::externalFunction( const ExternalMessage &msg )
{

	if ( msg.port() == update )
		{
			ifaisleOpen = true;
			doorTime = preparationTime + doorTime;
			holdIn(active, doorTime);

		}
		return *this ;
	}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &Timer::internalFunction( const InternalMessage & )
{
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &Timer::outputFunction( const InternalMessage &msg )
{
		if ( ifaisleOpen == true )
		{
				sendOutput( msg.time(), aisleOpen, true ) ;
		}

		return *this ;
}
