/*******************************************************************
*
*  DESCRIPTION:
*
*  AUTHOR:
*
*  EMAIL:
*
*  DATE:
*
*******************************************************************/

/** include files **/
#include "entrySensor.h"      // class EntrySensor
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )

/** public functions **/

/*******************************************************************
* Function Name:
* Description:
********************************************************************/
EntrySensor::EntrySensor( const string &name )
: Atomic( name )
, walk_in( addInputPort( "walk_in" ) )
, incr( addOutputPort( "incr" ) )
, preparationTime( 0, 0,15, 0 )

{
}

/*******************************************************************
* Function Name: initFunction
* Description:
* Precondition:
********************************************************************/
Model &EntrySensor::initFunction()
{
	holdIn( passive, Time::Zero );
	ifincr = false ;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &EntrySensor::externalFunction( const ExternalMessage &msg )
{
	if ( msg.port() == walk_in )
		{
			ifincr = true ;
			holdIn ( active, Time::Zero ) ;
		}

	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &EntrySensor::internalFunction( const InternalMessage & )
{
	passivate();
	return *this;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &EntrySensor::outputFunction( const InternalMessage &msg )
{
	if ( ifincr == true )
		{
			sendOutput( msg.time(), incr, true );
		}

		return *this ;
}
