/*******************************************************************
*
*  DESCRIPTION:
*
*  AUTHOR:
*
*  EMAIL:
*
*  DATE:
*
*******************************************************************/

/** include files **/
#include "exitSensor.h"      // class ExitSensor
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )

/** public functions **/

/*******************************************************************
* Function Name:
* Description:
********************************************************************/
ExitSensor::ExitSensor( const string &name )
: Atomic( name )
, walk_out( addInputPort( "walk_out" ) )
, decr( addOutputPort( "decr" ) )
, preparationTime( 0, 0,15, 0 )

{
}

/*******************************************************************
* Function Name: initFunction
* Description:
* Precondition:
********************************************************************/
Model &ExitSensor::initFunction()
{
	holdIn( passive, Time::Zero );
	ifdecr = false ;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &ExitSensor::externalFunction( const ExternalMessage &msg )
{

	if ( msg.port() == walk_out )
			{
				ifdecr = true ;
				holdIn ( active, Time::Zero ) ;
			}

	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &ExitSensor::internalFunction( const InternalMessage & )
{
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &ExitSensor::outputFunction( const InternalMessage &msg )
{
	if ( ifdecr == true )
	{
		sendOutput( msg.time(), decr, true ) ;

	}

	return *this ;
}
