#include(rules.inc)

[top]
components : plantcomp

[plantcomp]
type : cell
dim : (50, 50)
delay : transport
defaultDelayTime  : 100
border : nowrapped 
neighbors : plantcomp(-1,-1)  plantcomp(-1,0) plantcomp(-1,1)
neighbors : plantcomp(0,-1)   plantcomp(0,0)  plantcomp(0,1)
neighbors : plantcomp(1,-1)   plantcomp(1,0)  plantcomp(1,1)
localtransition : plantcomp-rule
initialValue : 0
initialCellsValue : 1c_x_1d.val
StateVariables: water rain_freq time_till_rain delta
StateValues: 60 10 10 0.00001
%InitialVariablesValue: initial.var
% '0' = empty cell;
% '1' = permanently destroyed cell(wall) ;
% '2' = cell occupied by c-species (dominant) ;
% '3' = cell occupied by d-species (better dispersing);
% '4' = freshly occupied by c-species;
% '5' = freshly occupied by d-species;

[plantcomp-rule]
%cell will die with probability 0.1
rule : 0 {#macro(CHANGE_VARS)} 100 { ((0,0) >= 2 and (0,0) < 6) and (randInt(9) = 0) }
rule : 0 {#macro(CHANGE_VARS)} 100 { (((0,0) >= 2 and (0, 0) < 3) or ((0,0) >= 4 and (0, 0) < 5)) and ($water < 20) }
rule : 0 {#macro(CHANGE_VARS)} 100 { (((0,0) >= 3 and (0, 0) < 4) or ((0,0) >= 5 and (0, 0) < 6)) and ($water < 5) }
%wall stays wall
rule : 1 100 { (0,0) = 1 }

%empty cell becames fresh c
rule : 4 {#macro(CHANGE_VARS)} 100 { ($water >= 60) and (((0,0) >= 0 and (0, 0) < 1) or ((0,0) >= 3 and (0, 0) < 4) or ((0,0) >= 5 and (0, 0) < 6)) and ( (((-1,-1) >= 2 and (-1,-1) < 3) and (randInt(4) = 0)) or (((-1,0) >= 2 and (-1,0) < 3) and (randInt(4) = 0)) or (((-1,1) >= 2 and (-1,1) < 3) and (randInt(4) = 0)) or (((0,-1) >= 2 and (0,-1) < 3) and (randInt(4) = 0)) or (((0,1) >= 2 and (0,1) < 3) and (randInt(4) = 0)) or (((1,-1) >= 2 and (1,-1) < 3) and (randInt(4) = 0)) or (((1,0) >= 2 and (1,0) < 3) and (randInt(4) = 0)) or (((1,1) >= 2 and (1,1) < 3) and (randInt(4) = 0)))}
%empty cell becames fresh d 
rule : 5 {#macro(CHANGE_VARS)} 100 { ($water >= 20) and (((0,0) >= 0 and (0, 0) < 1) ) and (( ((-1,-1) >= 3 and (-1,-1) < 4) and (randInt(1) = 0)) or (((-1,0) >= 3 and (-1,0) < 4) and (randInt(1) = 0)) or (((-1,1) >= 3 and (-1,1) < 4) and (randInt(1) = 0)) or (((0,-1) >= 3 and (0,-1) < 4) and (randInt(1) = 0)) or (((0,1) >= 3 and (0,1) < 4) and (randInt(1) = 0)) or (((1,-1) >= 3 and (1,-1) < 4) and (randInt(1) = 0)) or (((1,0) >= 3 and (1,0) < 4) and (randInt(1) = 0)) or (((1,1) >= 3 and (1,1) < 4) and (randInt(1) = 0)))}
%fresh c becames c
rule : 2 {#macro(CHANGE_VARS)} 100 { ((0,0) >= 4 and (0, 0) < 5) }
%fresh d becames d
rule : 3 {#macro(CHANGE_VARS)} 100 { ((0,0) >= 5 and (0, 0) < 6) }

rule : {0 + $delta} {#macro(CHANGE_VARS)} 100 {((0,0) >= 0 and (0, 0) < 1)}
rule : {2 + $delta} {#macro(CHANGE_VARS)} 100 {((0,0) >= 2 and (0, 0) < 3)}
rule : {3 + $delta} {#macro(CHANGE_VARS)} 100 {((0,0) >= 3 and (0, 0) < 4)}
rule : {4 + $delta} {#macro(CHANGE_VARS)} 100 {((0,0) >= 4 and (0, 0) < 5)}
rule : {5 + $delta} {#macro(CHANGE_VARS)} 100 {((0,0) >= 5 and (0, 0) < 6)}
