use strict;
use warnings;
use POSIX;

#This function is to retrieve the information from *.MA, to get the cell size 
#and to get the initial value
#

sub retrieve_cells_info
{
   my ($cells_matrix_ref,$ma_file) = @_;
     
   
   
   my $data_file=$ma_file;
   my $easting;
   my $northing;
   my $line;
   my ($x,$y,$z);
   my $initial;
   my $valuefile;
   #initial we have only one layer
   $z=1;
   
   open(my $fh,"<$data_file") or die("cannot open file $data_file \n");

   while( $line = <$fh> )
   {
           #print  "hello \n" ; 
	   #dim : (x,y,z)
	   #for three dimensions, we use the following statement
	   # z stands for the layer number
	   if($line =~ /\s*dim\s*\:\s*\(\s*(\d*)\,(\d*),(\d*)\)\s*/)
	   {
	     $x=$1;$y=$2;$z=$3;  
	   }
	   elsif($line =~ /\s*dim\s*\:\s*\(\s*(\d*)\,(\d*)\)\s*/)
	   {
	     $x=$1;$y=$2;     
	   }
	   elsif($line =~ /\s*initialvalue\s*\:\s*(\d*)\s*/)
	   {
	     $initial=$1;
	   }#initialCellsValue : urbangrowth.val
	   elsif($line =~ /\s*initialCellsValue\s*\:\s*(\w*\.val)\s*/)
	   {
	     $valuefile=$1;
	   }
   }
     
   close($fh);
    
   if($z==1)
   {
     print "\t"."this is a two dimensional layer.\n"
   }
   else
   {
     print "\t"."this has $z layers.\n"
   }
   
   for(my $z_idx=0; $z_idx<$z; $z_idx++)
   {
     for(my $y_idx=0; $y_idx<$y; $y_idx++)
     {
       for(my $x_idx=0; $x_idx<$x; $x_idx++)
       {
         $cells_matrix_ref->[$z_idx][$y_idx][$x_idx] = $initial;
       }
     }
   }
   
   open($fh,"<$valuefile") or die("cannot open file $data_file \n");
   
   if($z==1)
   {   
    while( $line = <$fh> )
    {
       #[-+]?[0-9]*\.?[0-9]+
       if($line =~ /\((\d*),(\d*)\)=(\d*)/)
       {
         $cells_matrix_ref->[$2][$1] = $3;
       }
    }
  }
  else
  {
     while( $line = <$fh> )
    {
       #[-+]?[0-9]*\.?[0-9]+
       if($line =~ /\((\d*),(\d*),(\d*)\)=(\d*)/)
       {
         $cells_matrix_ref->[$3][$2][$1] = $4;
       }
    }
    
  }
   close($fh);
	
}

sub gather_states_num
{
   my ($cells_matrix_ref) = @_;
   my $cells_layer = @$cells_matrix_ref;
   my $cells_row_num = $#{$cells_matrix_ref->[0]} + 1;
   my $cells_column_num = $#{$cells_matrix_ref->[0][0]} + 1;
   my $count=0;
   my @array;
   
   for(my $z_idx=0; $z_idx<$cells_layer; $z_idx++)
   {
     for(my $y_idx=0; $y_idx<$cells_row_num; $y_idx++)
     {
       for(my $x_idx=0; $x_idx<$cells_column_num; $x_idx++)
       {
          my $index = $cells_matrix_ref->[$z_idx][$y_idx][$x_idx];
          # print "index : $index \n";
          if(defined($array[$index]))
          {
            $array[$index]++;
          }else
          {
            $array[$index]=1;
            $count++;
            # print $count ;
          }
          
       }
     }
   }
   
   return $count ;
   
}

sub gather_state_style
{
   
   my ($state_style_array_ref,$index_map_state_ref)=@_;
   
   my $data_file="cell.style";

   my $line;
   my $count=0;
   my $colour;
   
   open(my $fh,"<$data_file") or die("cannot open file $data_file \n");
   # we read the longitude and latitude information
   while( $line = <$fh> )
   {
           # style 1  63B8FF  Population3
	   if($line =~ /^style\s*(\d*)\s*(\w\w)(\w\w)(\w\w)\s*(\w*)/)
	   {
               
               # print $1, $2, $3, $4, $5;
               # print "\n";
               $colour = "ff" . $4 . $3 . $2;
               $state_style_array_ref->[$1]=[$5,$colour];
               $index_map_state_ref->[$count]=$1;
               $count++;
               # print "@{$state_style_array_ref->[$1]}" . "\n" ;
	   }
   }
   close($fh);
   return $count;
  
}


1;