
/*
*main.cpp
*retrieve GIS geographic information and output to values.val
*
*notes:
*gdal should be included
*
*/


#include <iostream>
#include <fstream>
#include <iosfwd>

#include "gdal_priv.h"

#include "gdal.h"
#include "gdal_alg.h"
#include "ogr_srs_api.h"
#include "cpl_string.h"
#include "cpl_conv.h"
#include "cpl_multiproc.h"


#include "metodos.h"
#include "utils.h"

#define __DEBUG 0

using namespace std;

int main(int argc, char** argv) {


	GDALAllRegister();
	
    char *mapa_file;
	mapa_file = "F:\\landuse.tiff";
	char *archivoVal = "values.val";
	int metodo =0;

	GDALDataset  *poDataset;
	poDataset = (GDALDataset *) GDALOpen( mapa_file, GA_ReadOnly );
	printf("\nInitialization...\n");
	printf("Open File: %s\n", mapa_file);

    int cantidadDeBandas = poDataset->GetRasterCount();
    printf("\nnumber of bands: %d\n", cantidadDeBandas);
	
	 //descrption  
    printf( "\nDriver:%s/%s\n",  
        poDataset->GetDriver()->GetDescription(),  "\n",
        poDataset->GetDriver()->GetMetadataItem( GDAL_DMD_LONGNAME),"\n" );  
   
    //size and bandcount  
    printf( "Size is%dx%dx%d\n",  
        poDataset->GetRasterXSize(),poDataset->GetRasterYSize(), 
        poDataset->GetRasterCount(),"\n");  
        
    //projection  
    if( poDataset->GetProjectionRef() != NULL )  
        printf( "\nProjection is `%s'\n", poDataset->GetProjectionRef() );  
   
    //coordinate and resolution  
    double adfGeoTransform[6];  
    if( poDataset->GetGeoTransform( adfGeoTransform) == CE_None )  
    {  
        printf( "\nOrigin =(%.6f,%.6f)\n",  
            adfGeoTransform[0], adfGeoTransform[3]);  
   
        printf( "\nPixelSize = (%.6f,%.6f)\n",  
            adfGeoTransform[1], adfGeoTransform[5]);  
    }  
	
	int tamanoXBanda = poDataset->GetRasterBand(1)->GetXSize();
	int tamanoYBanda = poDataset->GetRasterBand(1)->GetYSize();
	if (__DEBUG) {
		printf("size band 1: %d x %d\n", tamanoXBanda, tamanoYBanda);
	}

	//generating values.val file
	ofstream fileVal;
	fileVal.open(archivoVal); 
	if (__DEBUG) {
		printf("file created: %s\n", archivoVal);
	}

	metodo1(poDataset, fileVal);

	fileVal.close();

	GDALClose(poDataset);
	return 0;
}
