#include(Supercooling2DExtMacros.inc)

[top]
components : supercooling2D

[supercooling2D]
type : cell
dim : (50,50)
delay : transport
defaultDelayTime  : 100
border : wrapped 
neighbors :                       supercooling2D(-1,0)
neighbors : supercooling2D(0,-1)  supercooling2D(0,0)  supercooling2D(0,1)
neighbors :                       supercooling2D(1,0) 
zone : insulatingTop-rule { (0,0)..(0,49) }
zone : insulatingBottom-rule { (49,0)..(49,49) }
initialValue : -1
initialCellsValue : supercooling2dext.val
stateVariables : latentHeat lambda diffusionRate initialTemperature
stateValues : -20 100 10 -36
neighborports: phase temperature
localtransition : supercooling2d-rule


[supercooling2d-rule]
%Initialization
rule : { ~phase := 0; ~temperature := $initialTemperature; } 100 { (0,0)~phase = -1 AND (0,0)~temperature = -1 }
rule : { ~phase := 1; ~temperature := $initialTemperature; } 100 { (0,0)~phase = -2 AND (0,0)~temperature = -2 }

%Ice Propagation
% Solidification and Latent Heat Release
rule : { ~phase := 1;~temperature := $latentHeat; } 100 { ((0,0)~phase = 0) AND ( #macro(C) >= 1) AND (#macro(temperature) < $lambda*(#macro(C)*(1 - #macro(C))) ) }
% Heat Conduction
rule : { ~temperature :=(0,0)~temperature -  $diffusionRate; } 100 { (0,0)~temperature - (((0,1)~temperature + (0,-1)~temperature + (1,0)~temperature + (-1,0)~temperature)/4) > $diffusionRate}
rule : { ~temperature :=(0,0)~temperature +  $diffusionRate; } 100 { (((0,1)~temperature + (0,-1)~temperature + (1,0)~temperature + (-1,0)~temperature)/4) - (0,0)~temperature > $diffusionRate}
rule : { ~temperature :=(((0,1)~temperature + (0,-1)~temperature + (1,0)~temperature + (-1,0)~temperature)/4); } 100 { t } 

[insulatingTop-rule]
%Initialization
rule : { ~phase := 0; ~temperature := $initialTemperature; } 100 { (0,0)~phase = -1 AND (0,0)~temperature = -1 }
rule : { ~phase := 1; ~temperature := $initialTemperature; } 100 { (0,0)~phase = -2 AND (0,0)~temperature = -2 }

%Ice Propagation
% Solidification and Latent Heat Release
rule : { ~phase := 1;~temperature := $latentHeat; } 100 { ((0,0)~phase = 0) AND ( #macro(CTop) >= 1) AND (#macro(temperature) < $lambda*(#macro(CTop)*(1 - #macro(CTop))) ) }
% Heat Conduction
rule : { ~temperature := (0,0)~temperature -  $diffusionRate; } 100 { (0,0)~temperature - (((0,1)~temperature + (0,-1)~temperature + 2*(1,0)~temperature)/4) > $diffusionRate } 
rule : { ~temperature := (0,0)~temperature +  $diffusionRate;  } 100 { (((0,1)~temperature + (0,-1)~temperature + 2*(1,0)~temperature)/4) - (0,0)~temperature > $diffusionRate } 
rule : { ~temperature := (((0,1)~temperature + (0,-1)~temperature + 2*(1,0)~temperature)/4); } 100 { t } 


[insulatingBottom-rule]
%Initialization
rule : { ~phase := 0; ~temperature := $initialTemperature; } 100 { (0,0)~phase = -1 AND (0,0)~temperature = -1 }
rule : { ~phase := 1; ~temperature := $initialTemperature; } 100 { (0,0)~phase = -2 AND (0,0)~temperature = -2 }

%Ice Propagation
% Solidification and Latent Heat Release
rule : { ~phase := 1;~temperature := $latentHeat; } 100 { ((0,0)~phase = 0) AND ( #macro(CBottom) >= 1) AND (#macro(temperature) < $lambda*(#macro(CBottom)*(1 - #macro(CBottom))) ) }
% Heat Conduction
rule : { ~temperature := (0,0)~temperature -  $diffusionRate; } 100 { (0,0)~temperature - (((0,1)~temperature + (0,-1)~temperature + 2*(-1,0)~temperature)/4) > $diffusionRate } 
rule : { ~temperature := (0,0)~temperature +  $diffusionRate;  } 100 { (((0,1)~temperature + (0,-1)~temperature + 2*(-1,0)~temperature)/4) - (0,0)~temperature > $diffusionRate } 
rule : { ~temperature := (((0,1)~temperature + (0,-1)~temperature + 2*(-1,0)~temperature)/4); } 100 { t } 
  